/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.plaf.addons.JYComboBoxAddon;
import de.javasoft.swing.plaf.basic.BasicJYComboBoxUI;
import de.javasoft.swing.plaf.synthetica.SyntheticaJYComboBoxUI;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;
import org.jdesktop.swingx.plaf.ComponentAddon;

public class JYComboBox
extends JComboBox {
    private static final long serialVersionUID = 3382303522321212791L;
    private JComponent popupComponent;
    private boolean popupResizable;
    private boolean popupSizeRestorable;
    private int popupWidth;
    private int popupHeight;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYComboBoxAddon());
    }

    public JYComboBox() {
        this.init();
    }

    public JYComboBox(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    private void init() {
        this.putClientProperty("Synthetica.popupType", 2);
        this.getEditor().getEditorComponent().setName("ComboBox.textField");
    }

    public void updateUI() {
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            this.setUI(new SyntheticaJYComboBoxUI());
        } else {
            this.setUI(new BasicJYComboBoxUI());
        }
        if (this.popupComponent != null) {
            SyntheticaAddonsUtilities.updateChildrenUI(this.popupComponent);
        }
    }

    public void setPopupWidth(int n) {
        int n2 = this.getPopupWidth();
        this.popupWidth = n;
        this.firePropertyChange("popupWidth", n2, n);
    }

    public int getPopupWidth() {
        return this.popupWidth;
    }

    public void setPopupHeight(int n) {
        int n2 = this.getPopupHeight();
        this.popupHeight = n;
        this.firePropertyChange("popupHeight", n2, n);
    }

    public int getPopupHeight() {
        return this.popupHeight;
    }

    public void setPopupResizable(boolean bl) {
        boolean bl2 = this.isPopupResizable();
        this.popupResizable = bl;
        this.firePropertyChange("popupResizable", bl2, bl);
    }

    public boolean isPopupResizable() {
        return this.popupResizable;
    }

    public void setPopupSizeRestorable(boolean bl) {
        boolean bl2 = this.isPopupSizeRestorable();
        this.popupSizeRestorable = bl;
        this.firePropertyChange("popupSizeRestorable", bl2, bl);
    }

    public boolean isPopupSizeRestorable() {
        return this.popupSizeRestorable;
    }

    public void setPopupComponent(JComponent jComponent) {
        JComponent jComponent2 = this.getPopupComponent();
        this.popupComponent = jComponent;
        this.firePropertyChange("popupComponent", jComponent2, this.popupComponent);
    }

    public JComponent getPopupComponent() {
        return this.popupComponent;
    }

    public void setItem(Object object) {
        this.addItem(object);
        this.setSelectedItem(object);
        if (this.getItemCount() > 1) {
            this.removeItemAt(0);
        }
    }

    public Object getItem() {
        return this.getSelectedItem();
    }

    public void closePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean bl) {
        if (bl) {
            super.setPopupVisible(true);
        } else {
            ComboBoxUI comboBoxUI = this.getUI();
            if (comboBoxUI instanceof SyntheticaJYComboBoxUI) {
                ((SyntheticaJYComboBoxUI)comboBoxUI).getPopup().setVisible(false);
            } else {
                ((BasicJYComboBoxUI)comboBoxUI).getPopup().setVisible(false);
            }
        }
    }

    public void cancelPopup() {
        this.getActionMap().get("hidePopup").actionPerformed(new ActionEvent(this, 1001, null));
    }
}

