/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.flexdock;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FlexdockPainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import org.flexdock.plaf.icons.IconMap;
import org.flexdock.plaf.icons.IconResource;
import org.flexdock.view.Button;
import org.flexdock.view.Titlebar;
import org.flexdock.view.actions.ActionFactory;

public class TitlebarUI
extends org.flexdock.plaf.theme.TitlebarUI {
    private TitlebarUI() {
        this.initializeCreationParameters();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TitlebarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        boolean bl = UIManager.get("Synthetica.flexdock.titlebar.background") != null;
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            String string;
            int n = 0;
            String string2 = string = bl ? UIManager.getString("Synthetica.flexdock.titlebar.font.style") : UIManager.getString("Synthetica.docking.titlebar.font.style");
            if (string != null) {
                if (string.contains("BOLD")) {
                    n |= 1;
                }
                if (string.contains("ITALIC")) {
                    n |= 2;
                }
            }
            int n2 = 0;
            n2 = bl ? (UIManager.getInt("Synthetica.flexdock.titlebar.font.size") == 0 ? UIManager.getFont("Panel.font").getSize() : UIManager.getInt("Synthetica.flexdock.titlebar.font.size")) : (UIManager.getInt("Synthetica.docking.titlebar.font.size") == 0 ? UIManager.getFont("Panel.font").getSize() : UIManager.getInt("Synthetica.docking.titlebar.font.size"));
            jComponent.setFont(new FontUIResource(UIManager.getFont("Panel.font").getFamily(), n, n2));
        }
    }

    protected void paintBackground(Graphics graphics, Titlebar titlebar) {
        Rectangle rectangle = this.getPaintRect(titlebar);
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        FlexdockPainter.getInstance().paintFlexdockTitleBarBackground((JComponent)titlebar, new SyntheticaState(titlebar.isActive() ? SyntheticaState.State.SELECTED.toInt() : 0), graphics, 0, 0, n, n2);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintTitle(Graphics graphics, Titlebar titlebar) {
        Serializable serializable;
        String string = titlebar.getText();
        SynthStyle synthStyle = SyntheticaLookAndFeel.getStyleFactory().getStyle((JComponent)titlebar, Region.INTERNAL_FRAME_TITLE_PANE);
        SynthContext synthContext = new SynthContext((JComponent)titlebar, Region.INTERNAL_FRAME_TITLE_PANE, synthStyle, 0);
        Rectangle rectangle = this.getPaintRect(titlebar);
        int n = rectangle.width;
        Component[] componentArray = titlebar.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            serializable = componentArray[n3];
            if (serializable instanceof Button && ((Component)serializable).isVisible() && ((Component)serializable).getBounds().width > 0) {
                int n4 = ((Button)serializable).getBounds().x;
                n = n4 < n ? n4 : n;
            }
            ++n3;
        }
        rectangle.width = n;
        serializable = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        FontMetrics fontMetrics = titlebar.getFontMetrics(titlebar.getFont());
        string = synthContext.getStyle().getGraphicsUtils(synthContext).layoutText(synthContext, fontMetrics, string, titlebar.getIcon(), 2, 0, 11, 0, rectangle, (Rectangle)serializable, rectangle2, this.getRightIconMargin() + this.getLeftIconMargin());
        graphics.setColor(this.getFontColor(titlebar.isActive()));
        synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle2.x, rectangle2.y, -2);
    }

    public void initializeCreationParameters() {
        boolean bl;
        this.setDefaultHeight(24);
        this.setInsets(new Insets(0, 0, 0, 0));
        boolean bl2 = bl = UIManager.get("Synthetica.flexdock.titlebar.background") != null;
        if (bl) {
            this.setInactiveFont(UIManager.getColor("Synthetica.flexdock.titlebar.color"));
            this.setActiveFont(UIManager.getColor("Synthetica.flexdock.titlebar.color.selected"));
        } else {
            this.setInactiveFont(UIManager.getColor("Synthetica.docking.titlebar.color"));
            this.setActiveFont(UIManager.getColor("Synthetica.docking.titlebar.color.selected"));
        }
        String string = bl ? "Synthetica.flexdock.titlebar" : "Synthetica.docking.titlebar";
        String string2 = String.valueOf(string) + ".active";
        Icon icon = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".close");
        Icon icon2 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".close");
        Icon icon3 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".close.hover");
        Icon icon4 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".close.hover");
        IconResource iconResource = new IconResource();
        iconResource.setIcon(icon);
        iconResource.setIconHover(icon3);
        iconResource.setIconDisabled(icon);
        iconResource.setIconActive(icon2);
        iconResource.setIconActiveHover(icon4);
        iconResource.setIconActiveDisabled(icon);
        iconResource.setIconPressed(icon2);
        iconResource.setIconSelected(icon);
        iconResource.setIconSelectedDisabled(icon);
        iconResource.setIconSelectedHover(icon3);
        iconResource.setIconSelectedActive(icon);
        iconResource.setIconSelectedActiveHover(icon3);
        iconResource.setIconSelectedActiveDisabled(icon);
        iconResource.setIconSelectedPressed(icon2);
        iconResource.setAction((Action)ActionFactory.createCloseAction());
        Icon icon5 = null;
        Icon icon6 = null;
        Icon icon7 = null;
        Icon icon8 = null;
        icon = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".maximize");
        icon2 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".maximize");
        icon3 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".maximize.hover");
        icon4 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".maximize.hover");
        icon5 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".restoreDock");
        icon6 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".restoreDock");
        icon7 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".restoreDock.hover");
        icon8 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".restoreDock.hover");
        if (bl) {
            icon = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".pin");
            icon2 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".pin");
            icon3 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".pin.hover");
            icon4 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".pin.hover");
            icon5 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".pin.docked");
            icon6 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".pin.docked");
            icon7 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".pin.docked.hover");
            icon8 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".pin.docked.hover");
        } else {
            icon = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".iconify");
            icon2 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".iconify");
            icon3 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".iconify.hover");
            icon4 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".iconify.hover");
            icon5 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".restore");
            icon6 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".restore");
            icon7 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".restore.hover");
            icon8 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".restore.hover");
        }
        IconResource iconResource2 = new IconResource();
        iconResource2.setIcon(icon);
        iconResource2.setIconHover(icon3);
        iconResource2.setIconDisabled(icon);
        iconResource2.setIconActive(icon2);
        iconResource2.setIconActiveHover(icon4);
        iconResource2.setIconActiveDisabled(icon);
        iconResource2.setIconPressed(icon2);
        iconResource2.setIconSelected(icon5);
        iconResource2.setIconSelectedDisabled(icon5);
        iconResource2.setIconSelectedHover(icon7);
        iconResource2.setIconSelectedActive(icon6);
        iconResource2.setIconSelectedActiveHover(icon8);
        iconResource2.setIconSelectedActiveDisabled(icon5);
        iconResource2.setIconSelectedPressed(icon6);
        iconResource2.setAction((Action)ActionFactory.createPinAction());
        icon = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".dock");
        icon2 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".dock");
        icon3 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".dock.hover");
        icon4 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".dock.hover");
        icon5 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".undock");
        icon6 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".undock");
        icon7 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string) + ".undock.hover");
        icon8 = SyntheticaLookAndFeel.loadIcon(String.valueOf(string2) + ".undock.hover");
        IconMap iconMap = new IconMap();
        iconMap.addIcons("close", iconResource);
        iconMap.addIcons("pin", iconResource2);
        this.setDefaultIcons(iconMap);
        this.setIconInsets(new Insets(0, 0, 0, 4));
        this.setButtonMargin(2);
        this.setAntialiasing(false);
    }
}

