/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.TablePainter;
import de.javasoft.util.JavaVersion;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.TableModel;
import sun.swing.table.DefaultTableCellHeaderRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SyntheticaHeaderRenderer
extends DefaultTableCellHeaderRenderer
implements UIResource {
    private static final long serialVersionUID = -4089492349514455249L;
    private JTable table;
    private int column;

    SyntheticaHeaderRenderer() {
        this.setHorizontalAlignment(SyntheticaLookAndFeel.getInt("Synthetica.tableHeader.horizontalAlignment", this, 10));
        this.setName("TableHeader.renderer");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        this.table = jTable;
        this.column = n2;
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (!bl2 && component instanceof JComponent && jTable != null && jTable.getTableHeader() != null && component instanceof JComponent) {
            JComponent object3 = (JComponent)component;
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(jTable.getTableHeader(), Region.TABLE_HEADER);
            object2 = new SynthContext(jTable.getTableHeader(), Region.TABLE_HEADER, synthStyle, 0);
            Insets insets = synthStyle.getInsets((SynthContext)object2, null);
            Border border = object3.getBorder();
            Border border2 = UIManager.getBorder("TableHeader.cellBorder");
            if (border2 != null) {
                if (border != border2) {
                    object3.setBorder(border2);
                }
            } else if (insets.equals(new Insets(0, 0, 0, 0))) {
                if (border == null) {
                    object3.setBorder(noFocusBorder);
                }
            } else {
                object3.setBorder(new EmptyBorder(insets));
            }
        }
        if (JavaVersion.JAVA6U10_OR_ABOVE && jTable != null && jTable.getRowSorter() != null) {
            for (RowSorter.SortKey sortKey : this.getSortKeys(jTable)) {
                if (sortKey.getColumn() != jTable.convertColumnIndexToModel(n2)) continue;
                object2 = null;
                switch (sortKey.getSortOrder()) {
                    case ASCENDING: {
                        object2 = UIManager.getIcon("Table.ascendingSortIcon");
                        break;
                    }
                    case DESCENDING: {
                        object2 = UIManager.getIcon("Table.descendingSortIcon");
                        break;
                    }
                    default: {
                        object2 = UIManager.getIcon("Table.naturalSortIcon");
                    }
                }
                this.setIcon((Icon)object2);
            }
        }
        return component;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.table != null) {
            int n = 0;
            boolean bl = false;
            int[] nArray = (int[])this.table.getClientProperty("SORTABLE_TABLE_SORTED_COLUMNS");
            Boolean bl2 = (Boolean)this.table.getClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND");
            if (nArray != null && bl2 != null && bl2.booleanValue()) {
                int[] nArray2 = nArray;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray2[n3];
                    if (n4 == this.column) {
                        TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), graphics, 0, 0, this.getWidth(), this.getHeight(), 1);
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            } else if (JavaVersion.JAVA6U10_OR_ABOVE && this.table.getRowSorter() != null) {
                for (RowSorter.SortKey sortKey : this.getSortKeys(this.table)) {
                    if (sortKey.getColumn() != this.table.convertColumnIndexToModel(this.column)) continue;
                    switch (sortKey.getSortOrder()) {
                        case ASCENDING: {
                            n = 1;
                            break;
                        }
                        case DESCENDING: {
                            n = 2;
                            break;
                        }
                    }
                    TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), graphics, 0, 0, this.getWidth(), this.getHeight(), n);
                    bl = true;
                }
            }
            if (!bl) {
                TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), graphics, 0, 0, this.getWidth(), this.getHeight(), n);
            }
        }
        super.paintComponent(graphics);
    }

    private List<RowSorter.SortKey> getSortKeys(JTable jTable) {
        RowSorter<? extends TableModel> rowSorter = jTable.getRowSorter();
        List<RowSorter.SortKey> list = rowSorter.getSortKeys();
        if (list.size() > 0) {
            list = new ArrayList<RowSorter.SortKey>();
            list.add(rowSorter.getSortKeys().get(0));
        }
        return list;
    }

    @Override
    public boolean isOpaque() {
        Boolean bl = (Boolean)SyntheticaLookAndFeel.get("Synthetica.tableHeader.opaque", this.table);
        return bl == null ? super.isOpaque() : bl.booleanValue();
    }
}

