(in-package :cl-isaac/test)

(define-test (cl-isaac isaac64)
  (with-fixtures '(*isaac64-ctx*)
    (setf *isaac64-ctx* (isaac:init-null-seed :is64 t))
    (of-type isaac:isaac64-ctx *isaac64-ctx*)
    (of-type null (isaac:generate-next-isaac64-block *isaac64-ctx*))
    (of-type (unsigned-byte 64) (isaac:rand64 *isaac64-ctx*))
    (is <= #xFF (integer-length (isaac:rand-bits-64 *isaac64-ctx* #xFF)))
    (true (isaac::incf-wrap64 (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                              (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))))
    (true (isaac:mix64 (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                       (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                       (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                       (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                       (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                       (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                       (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))
                       (aref (isaac64-ctx-randrsl *isaac64-ctx*) (random #xFF))))
    (true (isaac:scramble64 *isaac64-ctx*))))
