#include "myth_init.h"
#include "myth_sched.h"
#include "myth_worker.h"
#include "myth_io.h"
#include "myth_tls.h"
#include "myth_sync.h"

#include "myth_if_native.h"

#include "myth_worker_func.h"
#include "myth_io_func.h"
#include "myth_sync_func.h"
#include "myth_sched_func.h"
#include "myth_tls_func.h"

/*
   Function: myth_init

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_init(void)
{
	myth_init_body(0,0);
}

/*
   Function: myth_init_withparam

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_init_withparam(int worker_num,size_t def_stack_size)
{
	myth_init_body(worker_num,def_stack_size);
}

/*
   Function: myth_fini

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_fini(void)
{
	myth_fini_body();
}

/*
   Function: myth_init_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_init_ex(int worker_num,size_t def_stack_size)
{
	return myth_init_ex_body(worker_num,def_stack_size);
}

/*
   Function: myth_fini_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_fini_ex(void)
{
	myth_fini_ex_body();
}

/*
   Function: myth_exit_workers_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_exit_workers_ex(void)
{
	myth_notify_workers_exit();
}

/*
   Function: myth_ext_exit_workers_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_ext_exit_workers_ex(void)
{
	myth_exit_workers_ex();
}

/*
   Function: myth_worker_start_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_worker_start_ex(int rank)
{
	myth_worker_start_ex_body(rank);
}

/*
   Function: myth_startpoint_init_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_startpoint_init_ex(int rank)
{
	myth_startpoint_init_ex_body(rank);
}

/*
   Function: myth_startpoint_exit_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_startpoint_exit_ex(int rank)
{
	myth_startpoint_exit_ex_body(rank);
}

/*
   Function: myth_get_worker_num

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_get_worker_num(void)
{
	return myth_get_worker_num_body();
}

/*
   Function: myth_get_num_workers

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_get_num_workers(void)
{
	return myth_get_num_workers_body();
}

/*
   Function: myth_self

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_thread_t myth_self(void)
{
	return myth_self_body();
}

/*
   Function: myth_create

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_thread_t myth_create(myth_func_t func,void *arg)
{
	return myth_create_body(func,arg,0);
}

/*
   Function: myth_create_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_thread_t myth_create_ex(myth_func_t func,void *arg,myth_thread_option_t opt)
{
	return myth_create_ex_body(func,arg,opt);
}

/*
   Function: myth_exit

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_exit(void *ret)
{
	myth_exit_body(ret);
}

/*
   Function: myth_detach

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_detach(myth_thread_t th)
{
	myth_detach_body(th);
}

/*
   Function: myth_yield

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_yield(int force_worksteal)
{
	myth_yield_body(force_worksteal);
}

/*
   Function: myth_yield2

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_yield2(void)
{
	myth_yield2_body();
}

/*
   Function: myth_join

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_join(myth_thread_t th,void **result)
{
	myth_join_body(th,result);
}

int myth_setcancelstate(int state, int *oldstate)
{
	return myth_setcancelstate_body(state,oldstate);
}

int myth_setcanceltype(int type, int *oldtype)
{
	return myth_setcanceltype_body(type,oldtype);
}

int myth_cancel(myth_thread_t th)
{
	return myth_cancel_body(th);
}

void myth_testcancel(void)
{
	myth_testcancel_body();
}

/*
   Function: myth_key_create

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_key_create(myth_key_t *__key,void (*__destr_function) (void *))
{
	return myth_key_create_body(__key,__destr_function);
}

/*
   Function: myth_key_delete

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_key_delete(myth_key_t __key)
{
	return myth_key_delete_body(__key);
}

/*
   Function: myth_getspecific

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void *myth_getspecific(myth_key_t __key)
{
	return myth_getspecific_body(__key);
}

/*
   Function: myth_setspecific

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_setspecific(myth_key_t __key,void *__pointer)
{
	return myth_setspecific_body(__key,__pointer);
}

/*
   Function: myth_set_def_stack_size

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_set_def_stack_size(size_t newsize)
{
	myth_set_def_stack_size_body(newsize);
}

void myth_log_start(void)
{
	myth_log_start_body();
}

void myth_log_pause(void)
{
	myth_log_pause_body();
}

void myth_log_flush(void)
{
	myth_log_flush_body();
}

void myth_log_reset(void)
{
	myth_log_reset_body();
}

void myth_log_annotate_thread(myth_thread_t th,char *name)
{
	myth_log_annotate_thread_body(th,name);
}
/*
void myth_log_get_thread_annotation(myth_thread_t th,char *name)
{
	myth_log_get_thread_annotation_body(th,name);
}
*/

void myth_sched_prof_start(void)
{
	myth_sched_prof_start_body();
}

void myth_sched_prof_pause(void)
{
	myth_sched_prof_pause_body();
}

//Debug function
/*void myth_dprintf_1(char *func,char *fmt,...)
{
#ifdef MYTH_DEBUG
	static pthread_mutex_t mtx=PTHREAD_MUTEX_INITIALIZER;
	myth_running_env_t env;
	char tmp[1000];
	va_list ap;
	env=myth_get_current_env();
	va_start(ap,fmt);
	vsprintf(tmp,fmt,ap);
	va_end(ap);
	pthread_mutex_lock(&mtx);
	fprintf(stderr,"%s(%d):%s",func,env->rank,tmp);
	fflush(stderr);
	pthread_mutex_unlock(&mtx);
#endif
}*/

/*
   Function: myth_barrier_create

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_barrier_t myth_barrier_create(int nthreads)
{
	return myth_barrier_create_body(nthreads);
}

/*
   Function: myth_barrier_wait

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_barrier_wait(myth_barrier_t bar)
{
	return myth_barrier_wait_body(bar);
}

/*
   Function: myth_barrier_destroy

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_barrier_destroy(myth_barrier_t bar)
{
	return myth_barrier_destroy_body(bar);
}

//join counter:Implementation is not complete, not recommended for use
myth_jc_t myth_jc_create(int val)
{
	return myth_jc_create_body(val);
}

void myth_jc_wait(myth_jc_t jc)
{
	myth_jc_wait_body(jc);
}

void myth_jc_dec(myth_jc_t jc)
{
	myth_jc_dec_body(jc);
}

/*
   Function: myth_felock_create

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_felock_t myth_felock_create(void)
{
	return myth_felock_create_body();
}

/*
   Function: myth_felock_destroy

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_felock_destroy(myth_felock_t fe)
{
	return myth_felock_destroy_body(fe);
}

/*
   Function: myth_felock_lock

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_felock_lock(myth_felock_t fe)
{
	return myth_felock_lock_body(fe);
}

/*
   Function: myth_felock_wait_lock

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_felock_wait_lock(myth_felock_t fe,int val)
{
	return myth_felock_wait_lock_body(fe,val);
}

/*
   Function: myth_felock_unlock

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_felock_unlock(myth_felock_t fe)
{
	return myth_felock_unlock_body(fe);
}

/*
   Function: myth_felock_status

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_felock_status(myth_felock_t fe)
{
	return myth_felock_status_body(fe);
}

/*
   Function: myth_felock_set_unlock

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_felock_set_unlock(myth_felock_t fe,int val)
{
	return myth_felock_set_unlock_body(fe,val);
}

/*
   Function: myth_mutex_create

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_mutex_t myth_mutex_create(void)
{
	return myth_mutex_create_body();
}

/*
   Function: myth_mutex_destroy

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_mutex_destroy(myth_mutex_t mtx)
{
	myth_mutex_destroy_body(mtx);
}

/*
   Function: myth_mutex_trylock

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_mutex_trylock(myth_mutex_t mtx)
{
	return myth_mutex_trylock_body(mtx);
}

/*
   Function: myth_mutex_lock

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_mutex_lock(myth_mutex_t mtx)
{
	myth_mutex_lock_body(mtx);
}

/*
   Function: myth_mutex_unlock

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_mutex_unlock(myth_mutex_t mtx)
{
	myth_mutex_unlock_body(mtx);
}

/*
   Function: myth_cond_create

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_cond_t myth_cond_create(void)
{
	return myth_cond_create_body();
}

/*
   Function: myth_cond_destroy

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_cond_destroy(myth_cond_t c)
{
	myth_cond_destroy_body(c);
}

/*
   Function: myth_cond_signal

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_cond_signal(myth_cond_t c)
{
	myth_cond_signal_body(c);
}

/*
   Function: myth_cond_broadcast

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_cond_broadcast(myth_cond_t c)
{
	myth_cond_broadcast_body(c);
}

/*
   Function: myth_cond_wait

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_cond_wait (myth_cond_t c,myth_mutex_t mtx)
{
	myth_cond_wait_body(c,mtx);
}

/*
   Function: myth_custom_data_size

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
size_t myth_wsapi_get_hint_size(myth_thread_t th)
{
	if (th==NULL)th=myth_self();
	return th->custom_data_size;
}

/*
   Function: myth_custom_data_ptr

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void *myth_wsapi_get_hint_ptr(myth_thread_t th)
{
	if (th==NULL)th=myth_self();
	return th->custom_data_ptr;
}

/*
   Function: myth_set_custom_data

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_wsapi_set_hint(myth_thread_t th,void **data,size_t *size)
{
	if (th==NULL)th=myth_self();
	void *newdata=*data;size_t newsize=*size;
	*data=th->custom_data_ptr;*size=th->custom_data_size;
	th->custom_data_ptr=newdata;th->custom_data_size=newsize;
}

/*
   Function: myth_wsapi_rand

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
int myth_wsapi_rand(void)
{
	return myth_random(0,myth_get_num_workers());
}

/*
   Function: myth_wsapi_randarr

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
void myth_wsapi_randarr(int *ret,int n)
{
	int i,j;
	assert(n<=myth_get_num_workers());
	for (i=0;i<n;i++){
		while (1){
			int r;
			r=myth_wsapi_rand();
			for (j=0;j<i;j++){
				if (r==ret[j])break;
			}
			if (j==i){
				ret[i]=r;
				break;
			}
		}
	}
}

/*
   Function: myth_wsapi_runqueue_take_ex

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_thread_t myth_wsapi_runqueue_take(int victim,myth_wsapi_decidefn_t decidefn,void *udata)
{
	myth_thread_queue_t q;
	myth_wscache_t wc;
	myth_thread_t ret;
	int b,top;
	q=&g_envs[victim].runnable_q;
	wc=&q->wc;
#ifdef QUICK_CHECK_ON_STEAL
	if (q->top-q->base<=0){
		return NULL;
	}
#endif
#if defined USE_LOCK || defined USE_LOCK_TAKE
	myth_internal_lock_lock(&q->m_lock);
#endif
//#ifdef TRY_LOCK_BEFORE_STEAL
#if 1
	if (!myth_wsqueue_lock_trylock(&q->lock)){
		return NULL;
	}
#else
	myth_wsqueue_lock_lock(&q->lock);
#endif
	//Increment base
	b=q->base;
	q->base=b+1;
	myth_wsqueue_rwbarrier();
	top=q->top;
	if (b<top){
		ret=q->ptr[b];
		if ((!decidefn) || decidefn(ret,udata)){
			//q->ptr[b]=NULL;
			//invalidate cache
			//fprintf(stderr,"%d cache Invalidate\n",victim);
			//Increment sequence
			int s=wc->seq;
			wc->seq=s+1;
			myth_wsqueue_wbarrier();
			//Copy data
			wc->ptr=NULL;
			wc->size=0;
			//Increment sequence
			myth_wsqueue_wbarrier();
			wc->seq=s+2;
			myth_wsqueue_lock_unlock(&q->lock);
#if defined USE_LOCK || defined USE_LOCK_TAKE
			myth_internal_lock_unlock(&q->m_lock);
#endif
			return ret;
		}
		myth_wsqueue_wbarrier();
	}
	q->base=b;
	myth_wsqueue_lock_unlock(&q->lock);
#if defined USE_LOCK || defined USE_LOCK_TAKE
	myth_internal_lock_unlock(&q->m_lock);
#endif
	return NULL;
}

#if 1
/*
   Function: myth_wsapi_runqueue_peek

   TODO: description.

   Parameters:

      x - TODO: parameters.

   Returns:

      TODO: return value.

   See Also:

      TODO: see also.
*/
myth_thread_t myth_wsapi_runqueue_peek(int victim,void *ptr,size_t *psize)
{
	myth_thread_queue_t q;
	myth_wscache_t wc;
	q=&g_envs[victim].runnable_q;
	wc=&q->wc;
start:;
	//runqueue empty?
	if (q->top-q->base<=0){
		//empty,return NULL
		return NULL;
	}
	//Check cache status
	if (!wc->ptr){
		int b,top;
		//Update cache
		//Acquire lock
#if 1
		if (!myth_wsqueue_lock_trylock(&q->lock))goto start;
#else
		myth_wsqueue_lock_lock(&q->lock);
#endif
		//check status again
		if (!wc->ptr){
			//Increment base
			b=q->base;
			q->base=b+1;
			myth_wsqueue_rwbarrier();
			top=q->top;
			if (b<top){
				//fprintf(stderr,"%d cache update\n",victim);
				int s;
				myth_thread_t th;
				th=q->ptr[b];
				size_t thcs=myth_wsapi_get_hint_size(th);
				void* thcd=myth_wsapi_get_hint_ptr(th);
				//Copy data
				//Increment sequence
				s=wc->seq;
				wc->seq=s+1;
				myth_wsqueue_wbarrier();
				//Copy data
				wc->ptr=th;
				wc->size=(WS_CACHE_SIZE<thcs)?WS_CACHE_SIZE:thcs;
				memcpy(wc->data,thcd,wc->size);
				//Increment sequence
				myth_wsqueue_wbarrier();
				wc->seq=s+2;
				myth_wsqueue_wbarrier();
			}
			//Restore b
			q->base=b;
		}
		//Release lock
		myth_wsqueue_lock_unlock(&q->lock);
	}
	//read sequence
	//fprintf(stderr,"%d cache read\n",victim);
	int s0,s1;
	myth_thread_t ret;
	do{
		s0=wc->seq;
		myth_wsqueue_rbarrier();
		//Copy date from cache
		size_t ps=0;
		size_t cs=wc->size;
		ret=(myth_thread_t)wc->ptr;
		if (psize)ps=*psize;
		if (cs>0){
			cs=(cs<ps)?cs:ps;
			if (ptr)memcpy(ptr,wc->data,cs);
		}
		if (psize)*psize=cs;
		myth_wsqueue_rbarrier();
		s1=wc->seq;
	}while ((s0 & 1)||(s1^s0));
	return ret;
}
#elif 0
static int peekdata_fn(myth_thread_t th,void *udata)
{
	void **ud=(void**)udata;
	void *ptr=ud[0];
	size_t *psize=ud[1];
	size_t ps=0;
	size_t cs=myth_custom_data_size(th);
	if (psize)ps=*psize;
	if (cs>0){
		cs=(cs<ps)?cs:ps;
		if (ptr)memcpy(ptr,myth_custom_data_ptr(th),cs);
	}
	if (psize)*psize=cs;
	ud[2]=(void*)th;
	return 0;
}
myth_thread_t myth_wsapi_runqueue_peek(int victim,void *ptr,size_t *psize)
{
	void *udata[3]={ptr,(void*)psize,NULL};
	myth_wsapi_runqueue_take_ex(victim,peekdata_fn,(void*)&udata);
	return (myth_thread_t)udata[2];
}
#else
myth_thread_t myth_wsapi_runqueue_peek(int victim,void *ptr,size_t *psize)
{
	myth_thread_t ret;
	ret=myth_queue_peek(&g_envs[victim].runnable_q);
	if (ret){
		size_t csize=myth_custom_data_size(ret);
		if (psize && ptr && (*psize)>0){
			csize=((*psize)<csize)?(*psize):csize;
			*psize=csize;
			if (csize>0){
				memcpy(ptr,myth_custom_data_ptr(ret),csize);
			}
		}
	}
	else{
		if (psize)*psize=0;
	}
	return ret;
}
#endif

int myth_wsapi_runqueue_pass(int target,myth_thread_t th)
{
	//fprintf(stderr,"pass %d %p\n",target,th);
	return myth_queue_trypass(&g_envs[target].runnable_q,th);
}

void myth_wsapi_runqueue_push(myth_thread_t th)
{
	myth_running_env_t env=myth_get_current_env();
	myth_queue_push(&env->runnable_q,th);
}

myth_thread_t myth_wsapi_runqueue_pop(void)
{
	myth_running_env_t env=myth_get_current_env();
	return myth_queue_pop(&env->runnable_q);
}

//TODO: temporalily disable
#if 0

//serialize
void myth_serialize(myth_thread_t th,myth_pickle_t p)
{
	myth_serialize_body(th,p);
}

//Deserialize
myth_thread_t myth_deserialize(myth_pickle_t p)
{
	return myth_deserialize_body(p);
}
myth_thread_t myth_ext_deserialize(myth_pickle_t p)
{
	return myth_ext_deserialize_body(p);
}

myth_thread_t myth_steal(void)
{
	return myth_steal_body();
}

void myth_import(myth_thread_t th)
{
	myth_import_body(th);
}

void myth_ext_import(myth_thread_t th)
{
	myth_ext_import_body(th);
}

void myth_release_stack(myth_thread_t th)
{
	myth_release_stack_body(th);
}

void myth_release_desc(myth_thread_t th)
{
	myth_release_desc_body(th);
}
#endif
