chpl-venv
============

The Makefile in this third-party directory creates a Python virtualenv and
installs the python packages required by `chpldoc` and `start_test` inside it.

`chpldoc` uses several python packages to parse RST files and render them in
the various formats.

To re-install the packages, e.g. to pick up updates to the
sphinxcontrib-chapeldomain package, use this command:

```bash
gmake install-requirements

# or on mac, cygwin:
make install-requirements
```

Python Packages
---------------

The primary packages required by `chpldoc` are: `Sphinx`,
`sphinxcontrib-chapeldomain`, `sphinx_rtd_theme`, and `virtualenv` (for
installation). The dependencies for these packages are listed in the next
section.

The primary packages required by `start_test` are: `argparse`, `PyYAML`, and
`virtualenv` (for installation).

### Sphinx

Python documentation generator

Used to generate html, pdf, etc documentation from ReStructured Text generated
by `chpldoc`.

**License**: BSD

**Website**: https://pypi.python.org/pypi/Sphinx

### sphinxcontrib-chapeldomain

Sphinx extension that declares the Chapel language domain.

Used with Sphinx to parse Chapel directives in ReStructured Text generated by
`chpldoc`.

**License**: Apache v2.0

**Website**: https://pypi.python.org/pypi/sphinxcontrib-chapeldomain

### sphinx_rtd_theme

ReadTheDocs.org theme for Sphinx

Use with Sphinx as theme for html documentation.

**License**: MIT

**Website**: https://pypi.python.org/pypi/sphinx_rtd_theme

### argparse

Command line argument parsing library, backported from Python 2.7.

**License**: Python Software Foundation License

**Website**: https://pypi.python.org/pypi/argparse

### PyYAML

A YAML parser and emitter for Python

**License**: MIT

**Website**: https://pypi.python.org/pypi/PyYAML

### virtualenv

Virtual Python Environment builder

Used to create isolated environment to install other python packages, without
interfering with system python packages.

**License**: Python Software Foundation License

**Website**: https://pypi.python.org/pypi/virtualenv

Package Dependencies
--------------------

This section lists additional python packages that are installed in support of
those listed above.

### Jinja2

A small but fast and easy to use stand-alone template engine written in pure
python.

Required by Sphinx.

**License**: BSD

**Website**: https://pypi.python.org/pypi/Jinja2

### MarkupSafe

Implements a XML/HTML/XHTML Markup safe string for Python

Required by Sphinx.

**License**: BSD

**Website**: https://pypi.python.org/pypi/MarkupSafe

### Pygments

Pygments is a syntax highlighting package written in Python.

Required by Sphinx.

**License**: BSD

**Website**: https://pypi.python.org/pypi/Pygments

### docutils

Python Documentation Utilities

Required by Sphinx, and man page generation.

**License**: public domain, Python, 2-Clause BSD, GPL 3 (see COPYING.txt, also found at http://sourceforge.net/p/docutils/code/HEAD/tree/trunk/docutils/COPYING.txt)

**Website**: https://pypi.python.org/pypi/docutils
