(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      4772,        134]
NotebookOptionsPosition[      4438,        118]
NotebookOutlinePosition[      4797,        134]
CellTagsIndexPosition[      4754,        131]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Code", " ", "to", " ", "generate", " ", "tests", " ", "for", " ", "the", 
    " ", "FFTW", " ", "wrapper", " ", "routines"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.631380318636713*^9, 3.631380353051236*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Writer", " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "writeArr", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"writeArr", "[", 
      RowBox[{"dim_", ",", " ", "fn_"}], "]"}], ":=", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "fs"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"a", " ", "=", " ", 
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}], ",", "dim"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"b", " ", "=", " ", 
         RowBox[{"Fourier", "[", 
          RowBox[{"a", ",", 
           RowBox[{"FourierParameters", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"fs", " ", "=", " ", 
         RowBox[{"OpenWrite", "[", 
          RowBox[{"fn", ",", 
           RowBox[{"BinaryFormat", "\[Rule]", "True"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"BinaryWrite", "[", 
         RowBox[{"fs", ",", "dim", ",", "\"\<Integer32\>\"", ",", 
          RowBox[{"ByteOrdering", "\[Rule]", 
           RowBox[{"-", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"BinaryWrite", "[", 
         RowBox[{"fs", ",", "a", ",", " ", "\"\<Real64\>\"", ",", 
          RowBox[{"ByteOrdering", "\[Rule]", 
           RowBox[{"-", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"BinaryWrite", "[", 
         RowBox[{"fs", ",", "b", ",", " ", "\"\<Complex128\>\"", ",", 
          RowBox[{"ByteOrdering", "\[Rule]", 
           RowBox[{"-", "1"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Close", "[", "fs", "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6314031420946503`*^9, 3.631403228628937*^9}, 
   3.631403568538219*^9, {3.631403642441084*^9, 3.631403644567264*^9}, {
   3.6314859331654587`*^9, 3.631486000263154*^9}, {3.631486041501898*^9, 
   3.6314860593443947`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Do", " ", "the", " ", "1", "D", " ", "case", " ", "first"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SeedRandom", "[", "1234", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"writeArr", "[", 
     RowBox[{
      RowBox[{"{", "100", "}"}], ",", "\"\<arr1d.dat\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"writeArr", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"32", ",", "18"}], "}"}], ",", "\"\<arr2d.dat\>\""}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"writeArr", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"12", ",", "8", ",", "15"}], "}"}], ",", "\"\<arr3d.dat\>\""}],
      "]"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.63138035587591*^9, 3.631380473383889*^9}, {
   3.6313805422790413`*^9, 3.631380569161026*^9}, {3.6313806075965*^9, 
   3.6313806864208307`*^9}, {3.631402936953382*^9, 3.631402967845344*^9}, 
   3.6314032157246847`*^9, {3.631403283554654*^9, 3.631403340824667*^9}, {
   3.631403442566831*^9, 3.631403445589222*^9}, {3.631403498667458*^9, 
   3.631403572569734*^9}}]
},
WindowSize->{808, 751},
WindowMargins->{{237, Automatic}, {Automatic, 46}},
FrontEndVersion->"10.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September 9, \
2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 408, 10, 46, "Input"],
Cell[969, 32, 2257, 52, 199, "Input"],
Cell[3229, 86, 1205, 30, 148, "Input"]
}
]
*)

(* End of internal cache information *)
