/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
* Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

/*	CPU: Intel Core2Duo at 2660 MHz, 2 cores, SSE3
	OS: Microsoft WindowsXP 32-bit
	SVN: 5591 (modified)
	language: c.icl.opt
	timestamp: Dec 6, 2007; 13:44:1
	transform: DFT(256, 1)
	source file: "fft_256.c(.c)"
	performance: 9145 cycles, 2978 Mflop/s

algorithm: DFT_GT_CT( DFT(256, 1),
  GT_NthLoop( GT(DFT(16, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 16 ]),
    GT_Base( GT(DFT(16, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_CT( "T", DFT(16, 1),
        DFT_GT_CT( DFT(4, 1),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ) ),
        DFT_GT_CT( DFT(4, 1),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ) ) ) ),
    Info_Base( InfoNt(1) ) ),
  GT_NthLoop( GT(DFT(16, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 16 ]),
    GT_Base( GT(DFT(16, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_CT( "T", DFT(16, 1),
        DFT_GT_CT( DFT(4, 1),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ) ),
        DFT_GT_CT( DFT(4, 1),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ),
          GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
            GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
              DFT_Base( DFT(2, 1) ) ),
            Info_Base( InfoNt(1) ) ) ) ) ),
    Info_Base( InfoNt(1) ) ) )
*/

#include <include/omega64c.h>
static _Complex double D3[256];

void init_fft256() {
    for(int i404 = 0; i404 <= 15; i404++) {
        for(int i409 = 0; i409 <= 3; i409++) {
            for(int i417 = 0; i417 <= 1; i417++) {
                D3[((i404*16) + (i409*4) + (i417*2))] = omega(256, ((i409 + (i417*4))*i404));
                D3[((i404*16) + (i409*4) + (i417*2) + 1)] = omega(256, ((i409 + (i417*4) + 8)*i404));
            }
        }
    }
}

void fft256(_Complex double  *Y, _Complex double  *X) {
    static _Complex double T97[256];
    for(int i405 = 0; i405 <= 15; i405++) {
        _Complex double s752, s753, s754, s755, s756, s757, s758, 
            s759, s760, s761, s762, s763, s764, s765, s766, 
            s767, s768, s769, s770, s771, s772, s773, s774, 
            s775, s776, s777, s778, s779, s780, s781, s782, 
            s783, s784, t1438, t1439, t1440, t1441, t1442, t1443, 
            t1444, t1445, t1446, t1447, t1448, t1449, t1450, t1451, 
            t1452, t1453, t1454, t1455, t1456, t1457, t1458, t1459, 
            t1460, t1461, t1462, t1463, t1464, t1465, t1466, t1467, 
            t1468;
        int a663;
        s752 = X[i405];
        s753 = X[(i405 + 128)];
        t1438 = (s752 + s753);
        t1439 = (s752 - s753);
        s754 = X[(i405 + 64)];
        s755 = X[(192 + i405)];
        t1440 = (s754 + s755);
        t1441 = (t1438 + t1440);
        t1442 = (t1438 - t1440);
        s756 = (__I__*(s754 - s755));
        t1443 = (t1439 + s756);
        t1444 = (t1439 - s756);
        s757 = X[(i405 + 16)];
        s758 = X[(144 + i405)];
        t1445 = (s757 + s758);
        t1446 = (s757 - s758);
        s759 = X[(i405 + 80)];
        s760 = X[(208 + i405)];
        t1447 = (s759 + s760);
        t1448 = (t1445 + t1447);
        s761 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1445 - t1447));
        s762 = (__I__*(s759 - s760));
        s763 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t1446 + s762));
        s764 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1446 - s762));
        s765 = X[(i405 + 32)];
        s766 = X[(160 + i405)];
        t1449 = (s765 + s766);
        t1450 = (s765 - s766);
        s767 = X[(i405 + 96)];
        s768 = X[(224 + i405)];
        t1451 = (s767 + s768);
        t1452 = (t1449 + t1451);
        s769 = (__I__*(t1449 - t1451));
        s770 = (__I__*(s767 - s768));
        s771 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1450 + s770));
        s772 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1450 - s770));
        s773 = X[(i405 + 48)];
        s774 = X[(176 + i405)];
        t1453 = (s773 + s774);
        t1454 = (s773 - s774);
        s775 = X[(i405 + 112)];
        s776 = X[(240 + i405)];
        t1455 = (s775 + s776);
        t1456 = (t1453 + t1455);
        s777 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1453 - t1455));
        s778 = (__I__*(s775 - s776));
        s779 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1454 + s778));
        s780 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t1454 - s778));
        t1457 = (t1441 + t1452);
        t1458 = (t1441 - t1452);
        t1459 = (t1448 + t1456);
        a663 = (16*i405);
        T97[a663] = (t1457 + t1459);
        T97[(8 + a663)] = (t1457 - t1459);
        s781 = (__I__*(t1448 - t1456));
        T97[(4 + a663)] = (t1458 + s781);
        T97[(12 + a663)] = (t1458 - s781);
        t1460 = (t1443 + s771);
        t1461 = (t1443 - s771);
        t1462 = (s763 + s779);
        T97[(1 + a663)] = (t1460 + t1462);
        T97[(9 + a663)] = (t1460 - t1462);
        s782 = (__I__*(s763 - s779));
        T97[(5 + a663)] = (t1461 + s782);
        T97[(13 + a663)] = (t1461 - s782);
        t1463 = (t1442 + s769);
        t1464 = (t1442 - s769);
        t1465 = (s761 + s777);
        T97[(2 + a663)] = (t1463 + t1465);
        T97[(10 + a663)] = (t1463 - t1465);
        s783 = (__I__*(s761 - s777));
        T97[(6 + a663)] = (t1464 + s783);
        T97[(14 + a663)] = (t1464 - s783);
        t1466 = (t1444 + s772);
        t1467 = (t1444 - s772);
        t1468 = (s764 + s780);
        T97[(3 + a663)] = (t1466 + t1468);
        T97[(11 + a663)] = (t1466 - t1468);
        s784 = (__I__*(s764 - s780));
        T97[(7 + a663)] = (t1467 + s784);
        T97[(15 + a663)] = (t1467 - s784);
    }
    for(int i404 = 0; i404 <= 15; i404++) {
        _Complex double s883, s884, s885, s886, s887, s888, s889, 
            s890, s891, s892, s893, s894, s895, s896, s897, 
            s898, s899, s900, s901, s902, s903, s904, s905, 
            s906, s907, s908, s909, s910, s911, s912, s913, 
            s914, s915, t1597, t1598, t1599, t1600, t1601, t1602, 
            t1603, t1604, t1605, t1606, t1607, t1608, t1609, t1610, 
            t1611, t1612, t1613, t1614, t1615, t1616, t1617, t1618, 
            t1619, t1620, t1621, t1622, t1623, t1624, t1625, t1626, 
            t1627;
        int a788, a789, a790, a791, a792, a793, a794, 
            a795, a796, a797, a798, a799, a800, a801, a802, 
            a803;
        a788 = (i404 + 128);
        a789 = (16*i404);
        s883 = (D3[a789]*T97[i404]);
        s884 = (D3[(1 + a789)]*T97[a788]);
        t1597 = (s883 + s884);
        t1598 = (s883 - s884);
        a790 = (i404 + 64);
        a791 = (192 + i404);
        s885 = (D3[(2 + a789)]*T97[a790]);
        s886 = (D3[(3 + a789)]*T97[a791]);
        t1599 = (s885 + s886);
        t1600 = (t1597 + t1599);
        t1601 = (t1597 - t1599);
        s887 = (__I__*(s885 - s886));
        t1602 = (t1598 + s887);
        t1603 = (t1598 - s887);
        a792 = (i404 + 16);
        a793 = (144 + i404);
        s888 = (D3[(4 + a789)]*T97[a792]);
        s889 = (D3[(5 + a789)]*T97[a793]);
        t1604 = (s888 + s889);
        t1605 = (s888 - s889);
        a794 = (i404 + 80);
        a795 = (208 + i404);
        s890 = (D3[(6 + a789)]*T97[a794]);
        s891 = (D3[(7 + a789)]*T97[a795]);
        t1606 = (s890 + s891);
        t1607 = (t1604 + t1606);
        s892 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1604 - t1606));
        s893 = (__I__*(s890 - s891));
        s894 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t1605 + s893));
        s895 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1605 - s893));
        a796 = (i404 + 32);
        a797 = (160 + i404);
        s896 = (D3[(8 + a789)]*T97[a796]);
        s897 = (D3[(9 + a789)]*T97[a797]);
        t1608 = (s896 + s897);
        t1609 = (s896 - s897);
        a798 = (i404 + 96);
        a799 = (224 + i404);
        s898 = (D3[(10 + a789)]*T97[a798]);
        s899 = (D3[(11 + a789)]*T97[a799]);
        t1610 = (s898 + s899);
        t1611 = (t1608 + t1610);
        s900 = (__I__*(t1608 - t1610));
        s901 = (__I__*(s898 - s899));
        s902 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t1609 + s901));
        s903 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1609 - s901));
        a800 = (i404 + 48);
        a801 = (176 + i404);
        s904 = (D3[(12 + a789)]*T97[a800]);
        s905 = (D3[(13 + a789)]*T97[a801]);
        t1612 = (s904 + s905);
        t1613 = (s904 - s905);
        a802 = (i404 + 112);
        a803 = (240 + i404);
        s906 = (D3[(14 + a789)]*T97[a802]);
        s907 = (D3[(15 + a789)]*T97[a803]);
        t1614 = (s906 + s907);
        t1615 = (t1612 + t1614);
        s908 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t1612 - t1614));
        s909 = (__I__*(s906 - s907));
        s910 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t1613 + s909));
        s911 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t1613 - s909));
        t1616 = (t1600 + t1611);
        t1617 = (t1600 - t1611);
        t1618 = (t1607 + t1615);
        Y[i404] = (t1616 + t1618);
        Y[a788] = (t1616 - t1618);
        s912 = (__I__*(t1607 - t1615));
        Y[a790] = (t1617 + s912);
        Y[a791] = (t1617 - s912);
        t1619 = (t1602 + s902);
        t1620 = (t1602 - s902);
        t1621 = (s894 + s910);
        Y[a792] = (t1619 + t1621);
        Y[a793] = (t1619 - t1621);
        s913 = (__I__*(s894 - s910));
        Y[a794] = (t1620 + s913);
        Y[a795] = (t1620 - s913);
        t1622 = (t1601 + s900);
        t1623 = (t1601 - s900);
        t1624 = (s892 + s908);
        Y[a796] = (t1622 + t1624);
        Y[a797] = (t1622 - t1624);
        s914 = (__I__*(s892 - s908));
        Y[a798] = (t1623 + s914);
        Y[a799] = (t1623 - s914);
        t1625 = (t1603 + s903);
        t1626 = (t1603 - s903);
        t1627 = (s895 + s911);
        Y[a800] = (t1625 + t1627);
        Y[a801] = (t1625 - t1627);
        s915 = (__I__*(s895 - s911));
        Y[a802] = (t1626 + s915);
        Y[a803] = (t1626 - s915);
    }
}
