/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
* Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

/*	CPU: Intel Core2Duo at 2660 MHz, 2 cores, SSE3
	OS: Microsoft WindowsXP 32-bit
	SVN: 5591 (modified)
	language: c.icl.opt
	timestamp: Dec 6, 2007; 13:44:20
	transform: DFT(2048, 1)
	source file: "fft_2048.c(.c)"
	performance: 129333 cycles, 2316 Mflop/s

algorithm: DFT_GT_CT( DFT(2048, 1),
  GT_NthLoop( GT(DFT(64, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 32 ]),
    GT_Base( GT(DFT(64, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_GT_CT( DFT(64, 1),
        GT_NthLoop( GT(DFT(16, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 4 ]),
          GT_Base( GT(DFT(16, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_CT( "T", DFT(16, 1),
              DFT_GT_CT( DFT(4, 1),
                GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                  GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                    DFT_Base( DFT(2, 1) ) ),
                  Info_Base( InfoNt(1) ) ),
                GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                  GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                    DFT_Base( DFT(2, 1) ) ),
                  Info_Base( InfoNt(1) ) ) ),
              DFT_GT_CT( DFT(4, 1),
                GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                  GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                    DFT_Base( DFT(2, 1) ) ),
                  Info_Base( InfoNt(1) ) ),
                GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                  GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                    DFT_Base( DFT(2, 1) ) ),
                  Info_Base( InfoNt(1) ) ) ) ) ),
          Info_Base( InfoNt(1) ) ),
        GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 16 ]),
          GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(4, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ) ) ),
    Info_Base( InfoNt(1) ) ),
  GT_NthLoop( GT(DFT(32, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 64 ]),
    GT_Base( GT(DFT(32, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
      DFT_GT_CT( DFT(32, 1),
        GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 8 ]),
          GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(4, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ),
        GT_NthLoop( GT(DFT(8, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 4 ]),
          GT_Base( GT(DFT(8, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
            DFT_GT_CT( DFT(8, 1),
              GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 4 ]),
                GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_Base( DFT(2, 1) ) ),
                Info_Base( InfoNt(1) ) ),
              GT_NthLoop( GT(DFT(4, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                GT_Base( GT(DFT(4, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                  DFT_GT_CT( DFT(4, 1),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 0, 1 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ),
                    GT_NthLoop( GT(DFT(2, 1), XChain([ 0, 1 ]), XChain([ 1, 0 ]), [ 2 ]),
                      GT_Base( GT(DFT(2, 1), XChain([ 0 ]), XChain([ 0 ]), [  ]),
                        DFT_Base( DFT(2, 1) ) ),
                      Info_Base( InfoNt(1) ) ) ) ),
                Info_Base( InfoNt(1) ) ) ) ),
          Info_Base( InfoNt(1) ) ) ) ),
    Info_Base( InfoNt(1) ) ) )
*/

#include <include/omega64c.h>
static _Complex double D6[64];
static _Complex double D7[2048];

void init_fft2048() {
    for(int i850 = 0; i850 <= 3; i850++) {
        for(int i857 = 0; i857 <= 3; i857++) {
            for(int i867 = 0; i867 <= 1; i867++) {
                D6[((i850*16) + (i857*4) + (i867*2))] = omega(64, ((i857 + (i867*4))*i850));
                D6[((i850*16) + (i857*4) + (i867*2) + 1)] = omega(64, ((i857 + (i867*4) + 8)*i850));
            }
        }
    }
    for(int i848 = 0; i848 <= 31; i848++) {
        for(int i851 = 0; i851 <= 15; i851++) {
            for(int i859 = 0; i859 <= 1; i859++) {
                D7[((i848*64) + (i851*4) + (i859*2))] = omega(2048, ((i851 + (i859*16))*i848));
                D7[((i848*64) + (i851*4) + (i859*2) + 1)] = omega(2048, ((i851 + (i859*16) + 32)*i848));
            }
        }
    }
}

void fft2048(_Complex double  *Y, _Complex double  *X) {
    static _Complex double T199[2048];
    for(int i849 = 0; i849 <= 63; i849++) {
        _Complex double s2002, s2003, s2004, s2005, s2006, s2007, s2008, 
            s2009, s2010, s2011, s2012, s2013, s2014, s2015, s2016, 
            s2017, s2018, s2019, s2020, s2021, s2022, s2023, s2024, 
            s2025, s2026, s2027, s2028, s2029, s2030, s2031, s2032, 
            s2033, s2034, s2035, s2036, s2037, s2038, s2039, s2040, 
            s2041, s2042, s2043, s2044, s2045, s2046, s2047, s2048, 
            s2049, s2050, s2051, s2052, s2053, s2054, s2055, s2056, 
            s2057, s2058, s2059, s2060, s2061, s2062, s2063, s2064, 
            s2065, s2066, s2067, s2068, s2069, s2070, s2071, s2072, 
            s2073, s2074, s2075, s2076, s2077, s2078, s2079, s2080, 
            s2081, s2082, t3364, t3365, t3366, t3367, t3368, t3369, 
            t3370, t3371, t3372, t3373, t3374, t3375, t3376, t3377, 
            t3378, t3379, t3380, t3381, t3382, t3383, t3384, t3385, 
            t3386, t3387, t3388, t3389, t3390, t3391, t3392, t3393, 
            t3394, t3395, t3396, t3397, t3398, t3399, t3400, t3401, 
            t3402, t3403, t3404, t3405, t3406, t3407, t3408, t3409, 
            t3410, t3411, t3412, t3413, t3414, t3415, t3416, t3417, 
            t3418, t3419, t3420, t3421, t3422, t3423, t3424, t3425, 
            t3426, t3427, t3428, t3429, t3430, t3431, t3432, t3433, 
            t3434, t3435, t3436, t3437, t3438, t3439, t3440, t3441, 
            t3442;
        int a1701;
        s2002 = X[i849];
        s2003 = X[(i849 + 1024)];
        t3364 = (s2002 + s2003);
        t3365 = (s2002 - s2003);
        s2004 = X[(i849 + 512)];
        s2005 = X[(1536 + i849)];
        t3366 = (s2004 + s2005);
        t3367 = (t3364 + t3366);
        t3368 = (t3364 - t3366);
        s2006 = (__I__*(s2004 - s2005));
        t3369 = (t3365 + s2006);
        t3370 = (t3365 - s2006);
        s2007 = X[(i849 + 256)];
        s2008 = X[(1280 + i849)];
        t3371 = (s2007 + s2008);
        t3372 = (s2007 - s2008);
        s2009 = X[(i849 + 768)];
        s2010 = X[(1792 + i849)];
        t3373 = (s2009 + s2010);
        t3374 = (t3371 + t3373);
        s2011 = (__I__*(s2009 - s2010));
        t3375 = (t3367 + t3374);
        t3376 = (t3367 - t3374);
        s2012 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3372 + s2011));
        t3377 = (t3369 + s2012);
        t3378 = (t3369 - s2012);
        s2013 = (__I__*(t3371 - t3373));
        t3379 = (t3368 + s2013);
        t3380 = (t3368 - s2013);
        s2014 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3372 - s2011));
        t3381 = (t3370 + s2014);
        t3382 = (t3370 - s2014);
        s2015 = X[(i849 + 64)];
        s2016 = X[(1088 + i849)];
        t3383 = (s2015 + s2016);
        t3384 = (s2015 - s2016);
        s2017 = X[(i849 + 576)];
        s2018 = X[(1600 + i849)];
        t3385 = (s2017 + s2018);
        t3386 = (t3383 + t3385);
        t3387 = (t3383 - t3385);
        s2019 = (__I__*(s2017 - s2018));
        t3388 = (t3384 + s2019);
        t3389 = (t3384 - s2019);
        s2020 = X[(i849 + 320)];
        s2021 = X[(1344 + i849)];
        t3390 = (s2020 + s2021);
        t3391 = (s2020 - s2021);
        s2022 = X[(i849 + 832)];
        s2023 = X[(1856 + i849)];
        t3392 = (s2022 + s2023);
        t3393 = (t3390 + t3392);
        s2024 = (__I__*(s2022 - s2023));
        t3394 = (t3386 + t3393);
        s2025 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3391 + s2024));
        s2026 = (__I__*(t3390 - t3392));
        s2027 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3391 - s2024));
        s2028 = X[(i849 + 128)];
        s2029 = X[(1152 + i849)];
        t3395 = (s2028 + s2029);
        t3396 = (s2028 - s2029);
        s2030 = X[(i849 + 640)];
        s2031 = X[(1664 + i849)];
        t3397 = (s2030 + s2031);
        t3398 = (t3395 + t3397);
        t3399 = (t3395 - t3397);
        s2032 = (__I__*(s2030 - s2031));
        t3400 = (t3396 + s2032);
        t3401 = (t3396 - s2032);
        s2033 = X[(i849 + 384)];
        s2034 = X[(1408 + i849)];
        t3402 = (s2033 + s2034);
        t3403 = (s2033 - s2034);
        s2035 = X[(i849 + 896)];
        s2036 = X[(1920 + i849)];
        t3404 = (s2035 + s2036);
        t3405 = (t3402 + t3404);
        s2037 = (__I__*(s2035 - s2036));
        t3406 = (t3398 + t3405);
        s2038 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3403 + s2037));
        s2039 = (__I__*(t3402 - t3404));
        s2040 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3403 - s2037));
        s2041 = X[(i849 + 192)];
        s2042 = X[(1216 + i849)];
        t3407 = (s2041 + s2042);
        t3408 = (s2041 - s2042);
        s2043 = X[(i849 + 704)];
        s2044 = X[(1728 + i849)];
        t3409 = (s2043 + s2044);
        t3410 = (t3407 + t3409);
        t3411 = (t3407 - t3409);
        s2045 = (__I__*(s2043 - s2044));
        t3412 = (t3408 + s2045);
        t3413 = (t3408 - s2045);
        s2046 = X[(i849 + 448)];
        s2047 = X[(1472 + i849)];
        t3414 = (s2046 + s2047);
        t3415 = (s2046 - s2047);
        s2048 = X[(i849 + 960)];
        s2049 = X[(1984 + i849)];
        t3416 = (s2048 + s2049);
        t3417 = (t3414 + t3416);
        s2050 = (__I__*(s2048 - s2049));
        t3418 = (t3410 + t3417);
        s2051 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3415 + s2050));
        s2052 = (__I__*(t3414 - t3416));
        s2053 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3415 - s2050));
        t3419 = (t3375 + t3406);
        t3420 = (t3375 - t3406);
        t3421 = (t3394 + t3418);
        a1701 = (32*i849);
        T199[a1701] = (t3419 + t3421);
        T199[(16 + a1701)] = (t3419 - t3421);
        s2054 = (__I__*(t3394 - t3418));
        T199[(8 + a1701)] = (t3420 + s2054);
        T199[(24 + a1701)] = (t3420 - s2054);
        s2055 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t3400 + s2038));
        t3422 = (t3377 + s2055);
        t3423 = (t3377 - s2055);
        s2056 = ((0.98078528040323043 + __I__ * 0.19509032201612825)*(t3388 + s2025));
        s2057 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t3412 + s2051));
        t3424 = (s2056 + s2057);
        T199[(1 + a1701)] = (t3422 + t3424);
        T199[(17 + a1701)] = (t3422 - t3424);
        s2058 = (__I__*(s2056 - s2057));
        T199[(9 + a1701)] = (t3423 + s2058);
        T199[(25 + a1701)] = (t3423 - s2058);
        s2059 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3399 + s2039));
        t3425 = (t3379 + s2059);
        t3426 = (t3379 - s2059);
        s2060 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t3387 + s2026));
        s2061 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t3411 + s2052));
        t3427 = (s2060 + s2061);
        T199[(2 + a1701)] = (t3425 + t3427);
        T199[(18 + a1701)] = (t3425 - t3427);
        s2062 = (__I__*(s2060 - s2061));
        T199[(10 + a1701)] = (t3426 + s2062);
        T199[(26 + a1701)] = (t3426 - s2062);
        s2063 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t3401 + s2040));
        t3428 = (t3381 + s2063);
        t3429 = (t3381 - s2063);
        s2064 = ((0.83146961230254524 + __I__ * 0.55557023301960218)*(t3389 + s2027));
        s2065 = ((-0.19509032201612825 + __I__ * 0.98078528040323043)*(t3413 + s2053));
        t3430 = (s2064 + s2065);
        T199[(3 + a1701)] = (t3428 + t3430);
        T199[(19 + a1701)] = (t3428 - t3430);
        s2066 = (__I__*(s2064 - s2065));
        T199[(11 + a1701)] = (t3429 + s2066);
        T199[(27 + a1701)] = (t3429 - s2066);
        s2067 = (__I__*(t3398 - t3405));
        t3431 = (t3376 + s2067);
        t3432 = (t3376 - s2067);
        s2068 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3386 - t3393));
        s2069 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3410 - t3417));
        t3433 = (s2068 + s2069);
        T199[(4 + a1701)] = (t3431 + t3433);
        T199[(20 + a1701)] = (t3431 - t3433);
        s2070 = (__I__*(s2068 - s2069));
        T199[(12 + a1701)] = (t3432 + s2070);
        T199[(28 + a1701)] = (t3432 - s2070);
        s2071 = ((-0.38268343236508978 + __I__ * 0.92387953251128674)*(t3400 - s2038));
        t3434 = (t3378 + s2071);
        t3435 = (t3378 - s2071);
        s2072 = ((0.55557023301960218 + __I__ * 0.83146961230254524)*(t3388 - s2025));
        s2073 = ((-0.98078528040323043 + __I__ * 0.19509032201612825)*(t3412 - s2051));
        t3436 = (s2072 + s2073);
        T199[(5 + a1701)] = (t3434 + t3436);
        T199[(21 + a1701)] = (t3434 - t3436);
        s2074 = (__I__*(s2072 - s2073));
        T199[(13 + a1701)] = (t3435 + s2074);
        T199[(29 + a1701)] = (t3435 - s2074);
        s2075 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3399 - s2039));
        t3437 = (t3380 + s2075);
        t3438 = (t3380 - s2075);
        s2076 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t3387 - s2026));
        s2077 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t3411 - s2052));
        t3439 = (s2076 + s2077);
        T199[(6 + a1701)] = (t3437 + t3439);
        T199[(22 + a1701)] = (t3437 - t3439);
        s2078 = (__I__*(s2076 - s2077));
        T199[(14 + a1701)] = (t3438 + s2078);
        T199[(30 + a1701)] = (t3438 - s2078);
        s2079 = ((-0.92387953251128674 + __I__ * 0.38268343236508978)*(t3401 - s2040));
        t3440 = (t3382 + s2079);
        t3441 = (t3382 - s2079);
        s2080 = ((0.19509032201612825 + __I__ * 0.98078528040323043)*(t3389 - s2027));
        s2081 = ((-0.55557023301960218 - __I__ * 0.83146961230254524)*(t3413 - s2053));
        t3442 = (s2080 + s2081);
        T199[(7 + a1701)] = (t3440 + t3442);
        T199[(23 + a1701)] = (t3440 - t3442);
        s2082 = (__I__*(s2080 - s2081));
        T199[(15 + a1701)] = (t3441 + s2082);
        T199[(31 + a1701)] = (t3441 - s2082);
    }
    for(int i848 = 0; i848 <= 31; i848++) {
        static _Complex double T218[64];
        for(int i851 = 0; i851 <= 15; i851++) {
            _Complex double s2101, s2102, s2103, s2104, s2105, t3459, t3460, 
                t3461;
            int a1751, a1752, a1753;
            a1751 = (i848 + (32*i851));
            a1752 = (4*i851);
            a1753 = ((64*i848) + a1752);
            s2101 = (D7[a1753]*T199[a1751]);
            s2102 = (D7[(a1753 + 1)]*T199[(a1751 + 1024)]);
            t3459 = (s2101 + s2102);
            t3460 = (s2101 - s2102);
            s2103 = (D7[(a1753 + 2)]*T199[(a1751 + 512)]);
            s2104 = (D7[(a1753 + 3)]*T199[(a1751 + 1536)]);
            t3461 = (s2103 + s2104);
            T218[a1752] = (t3459 + t3461);
            T218[(a1752 + 2)] = (t3459 - t3461);
            s2105 = (__I__*(s2103 - s2104));
            T218[(a1752 + 1)] = (t3460 + s2105);
            T218[(3 + a1752)] = (t3460 - s2105);
        }
        for(int i850 = 0; i850 <= 3; i850++) {
            _Complex double s2204, s2205, s2206, s2207, s2208, s2209, s2210, 
                s2211, s2212, s2213, s2214, s2215, s2216, s2217, s2218, 
                s2219, s2220, s2221, s2222, s2223, s2224, s2225, s2226, 
                s2227, s2228, s2229, s2230, s2231, s2232, s2233, s2234, 
                s2235, s2236, t3590, t3591, t3592, t3593, t3594, t3595, 
                t3596, t3597, t3598, t3599, t3600, t3601, t3602, t3603, 
                t3604, t3605, t3606, t3607, t3608, t3609, t3610, t3611, 
                t3612, t3613, t3614, t3615, t3616, t3617, t3618, t3619, 
                t3620;
            int a1912, a1913;
            a1912 = (16*i850);
            s2204 = (D6[a1912]*T218[i850]);
            s2205 = (D6[(1 + a1912)]*T218[(i850 + 32)]);
            t3590 = (s2204 + s2205);
            t3591 = (s2204 - s2205);
            s2206 = (D6[(2 + a1912)]*T218[(i850 + 16)]);
            s2207 = (D6[(3 + a1912)]*T218[(48 + i850)]);
            t3592 = (s2206 + s2207);
            t3593 = (t3590 + t3592);
            t3594 = (t3590 - t3592);
            s2208 = (__I__*(s2206 - s2207));
            t3595 = (t3591 + s2208);
            t3596 = (t3591 - s2208);
            s2209 = (D6[(4 + a1912)]*T218[(i850 + 4)]);
            s2210 = (D6[(5 + a1912)]*T218[(36 + i850)]);
            t3597 = (s2209 + s2210);
            t3598 = (s2209 - s2210);
            s2211 = (D6[(6 + a1912)]*T218[(i850 + 20)]);
            s2212 = (D6[(7 + a1912)]*T218[(52 + i850)]);
            t3599 = (s2211 + s2212);
            t3600 = (t3597 + t3599);
            s2213 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3597 - t3599));
            s2214 = (__I__*(s2211 - s2212));
            s2215 = ((0.92387953251128674 + __I__ * 0.38268343236508978)*(t3598 + s2214));
            s2216 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t3598 - s2214));
            s2217 = (D6[(8 + a1912)]*T218[(i850 + 8)]);
            s2218 = (D6[(9 + a1912)]*T218[(40 + i850)]);
            t3601 = (s2217 + s2218);
            t3602 = (s2217 - s2218);
            s2219 = (D6[(10 + a1912)]*T218[(i850 + 24)]);
            s2220 = (D6[(11 + a1912)]*T218[(56 + i850)]);
            t3603 = (s2219 + s2220);
            t3604 = (t3601 + t3603);
            s2221 = (__I__*(t3601 - t3603));
            s2222 = (__I__*(s2219 - s2220));
            s2223 = ((0.70710678118654757 + __I__ * 0.70710678118654757)*(t3602 + s2222));
            s2224 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3602 - s2222));
            s2225 = (D6[(12 + a1912)]*T218[(i850 + 12)]);
            s2226 = (D6[(13 + a1912)]*T218[(44 + i850)]);
            t3605 = (s2225 + s2226);
            t3606 = (s2225 - s2226);
            s2227 = (D6[(14 + a1912)]*T218[(i850 + 28)]);
            s2228 = (D6[(15 + a1912)]*T218[(60 + i850)]);
            t3607 = (s2227 + s2228);
            t3608 = (t3605 + t3607);
            s2229 = ((-0.70710678118654757 + __I__ * 0.70710678118654757)*(t3605 - t3607));
            s2230 = (__I__*(s2227 - s2228));
            s2231 = ((0.38268343236508978 + __I__ * 0.92387953251128674)*(t3606 + s2230));
            s2232 = ((-0.92387953251128674 - __I__ * 0.38268343236508978)*(t3606 - s2230));
            t3609 = (t3593 + t3604);
            t3610 = (t3593 - t3604);
            t3611 = (t3600 + t3608);
            a1913 = (i848 + (32*i850));
            Y[a1913] = (t3609 + t3611);
            Y[(a1913 + 1024)] = (t3609 - t3611);
            s2233 = (__I__*(t3600 - t3608));
            Y[(a1913 + 512)] = (t3610 + s2233);
            Y[(a1913 + 1536)] = (t3610 - s2233);
            t3612 = (t3595 + s2223);
            t3613 = (t3595 - s2223);
            t3614 = (s2215 + s2231);
            Y[(a1913 + 128)] = (t3612 + t3614);
            Y[(a1913 + 1152)] = (t3612 - t3614);
            s2234 = (__I__*(s2215 - s2231));
            Y[(a1913 + 640)] = (t3613 + s2234);
            Y[(a1913 + 1664)] = (t3613 - s2234);
            t3615 = (t3594 + s2221);
            t3616 = (t3594 - s2221);
            t3617 = (s2213 + s2229);
            Y[(a1913 + 256)] = (t3615 + t3617);
            Y[(a1913 + 1280)] = (t3615 - t3617);
            s2235 = (__I__*(s2213 - s2229));
            Y[(a1913 + 768)] = (t3616 + s2235);
            Y[(a1913 + 1792)] = (t3616 - s2235);
            t3618 = (t3596 + s2224);
            t3619 = (t3596 - s2224);
            t3620 = (s2216 + s2232);
            Y[(a1913 + 384)] = (t3618 + t3620);
            Y[(a1913 + 1408)] = (t3618 - t3620);
            s2236 = (__I__*(s2216 - s2232));
            Y[(a1913 + 896)] = (t3619 + s2236);
            Y[(a1913 + 1920)] = (t3619 - s2236);
        }
    }
}
