/***************************************************************
This code was generated by  Spiral 5.0 beta, www.spiral.net --
Copyright (c) 2005, Carnegie Mellon University
All rights reserved.
The code is distributed under a BSD style license
(see http://www.opensource.org/licenses/bsd-license.php)

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
  notice, reference to Spiral, this list of conditions and the
  following disclaimer.
  * Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials provided
  with the distribution.
  * Neither the name of Carnegie Mellon University nor the name of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*AS IS* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************/

use omega;
var  buf3: [0..255] complex;
var  buf4: [0..63] complex;
var  dat5: [0..123] complex;
var  dat6: [0..123] complex;
var  dat7: [0..27] complex;
var  dat8: [0..27] complex;

proc init_fft256() {
  for i4196 in 0..30 {
    for i4206 in 0..1 {
      dat5(((i4196*4) + (i4206*2))) = omega(256, ((i4196 + 1)*i4206));
      dat5(((i4196*4) + (i4206*2) + 1)) = omega(256, ((i4196 + 1)*(i4206 + 2)));
    }
  }
  for i4197 in 0..30 {
    for i4214 in 0..1 {
      dat6(((i4197*4) + (i4214*2))) = omega(256, ((33 + i4197)*i4214));
      dat6(((i4197*4) + (i4214*2) + 1)) = omega(256, ((33 + i4197)*(i4214 + 2)));
    }
  }
  for i4216 in 0..6 {
    for i4226 in 0..1 {
      dat7(((i4216*4) + (i4226*2))) = omega(64, ((i4216 + 1)*i4226));
      dat7(((i4216*4) + (i4226*2) + 1)) = omega(64, ((i4216 + 1)*(i4226 + 2)));
    }
  }
  for i4217 in 0..6 {
    for i4234 in 0..1 {
      dat8(((i4217*4) + (i4234*2))) = omega(64, ((9 + i4217)*i4234));
      dat8(((i4217*4) + (i4234*2) + 1)) = omega(64, ((9 + i4217)*(i4234 + 2)));
    }
  }

}

proc fft256(Y: [] complex, X: [] complex) {
  for i4198 in 0..3 {
    for i4218 in 0..3 {
      var a6523, a6524, a6525, a6526, a6528, a6529, a6530, a6531, s2699, s2700, s2701, s2702, s2703, s2704, s2705, s2706, s2707, s2708, s2709, s2710, s2711, s2712, s2713, s2714, s2715, s2716, s2717, s2718, s2719, s2720, s2721, s2722, s2723, t6973, t6974, t6975, t6976, t6977, t6978, t6979, t6980, t6981, t6982, t6983, t6984, t6985, t6986, t6987, t6988, t6989, t6990, t6991, t6992, t6993, t6994, t6995, t6996, t6997, t6998, t6999, t7000, t7001, t7002, t7003:complex;
      var a6522, a6527:int;
      a6522 = (i4198 + (4*i4218));
      s2699 = X(a6522);
      s2700 = X((a6522 + 128));
      t6973 = (s2699 + s2700);
      t6974 = (s2699 - s2700);
      s2701 = X((a6522 + 64));
      s2702 = X((a6522 + 192));
      t6975 = (s2701 + s2702);
      t6976 = (t6973 + t6975);
      t6977 = (t6973 - t6975);
      a6523 = (1.0i*(s2701 - s2702));
      t6978 = (t6974 + a6523);
      t6979 = (t6974 - a6523);
      s2703 = X((a6522 + 16));
      s2704 = X((a6522 + 144));
      t6980 = (s2703 + s2704);
      t6981 = (s2703 - s2704);
      s2705 = X((a6522 + 80));
      s2706 = X((a6522 + 208));
      t6982 = (s2705 + s2706);
      t6983 = (t6980 + t6982);
      s2707 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6980 - t6982));
      a6524 = (1.0i*(s2705 - s2706));
      s2708 = ((0.92387953251128674 + 1.0i * 0.38268343236508978)*(t6981 + a6524));
      s2709 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t6981 - a6524));
      s2710 = X((a6522 + 32));
      s2711 = X((a6522 + 160));
      t6984 = (s2710 + s2711);
      t6985 = (s2710 - s2711);
      s2712 = X((a6522 + 96));
      s2713 = X((a6522 + 224));
      t6986 = (s2712 + s2713);
      t6987 = (t6984 + t6986);
      s2714 = (1.0i*(t6984 - t6986));
      a6525 = (1.0i*(s2712 - s2713));
      s2715 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6985 + a6525));
      s2716 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6985 - a6525));
      s2717 = X((a6522 + 48));
      s2718 = X((a6522 + 176));
      t6988 = (s2717 + s2718);
      t6989 = (s2717 - s2718);
      s2719 = X((a6522 + 112));
      s2720 = X((a6522 + 240));
      t6990 = (s2719 + s2720);
      t6991 = (t6988 + t6990);
      s2721 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(t6988 - t6990));
      a6526 = (1.0i*(s2719 - s2720));
      s2722 = ((0.38268343236508978 + 1.0i * 0.92387953251128674)*(t6989 + a6526));
      s2723 = ((-0.92387953251128674 - 1.0i * 0.38268343236508978)*(t6989 - a6526));
      t6992 = (t6976 + t6987);
      t6993 = (t6976 - t6987);
      t6994 = (t6983 + t6991);
      a6527 = (16*i4218);
      buf4(a6527) = (t6992 + t6994);
      buf4((8 + a6527)) = (t6992 - t6994);
      a6528 = (1.0i*(t6983 - t6991));
      buf4((4 + a6527)) = (t6993 + a6528);
      buf4((12 + a6527)) = (t6993 - a6528);
      t6995 = (t6978 + s2715);
      t6996 = (t6978 - s2715);
      t6997 = (s2708 + s2722);
      buf4((1 + a6527)) = (t6995 + t6997);
      buf4((9 + a6527)) = (t6995 - t6997);
      a6529 = (1.0i*(s2708 - s2722));
      buf4((5 + a6527)) = (t6996 + a6529);
      buf4((13 + a6527)) = (t6996 - a6529);
      t6998 = (t6977 + s2714);
      t6999 = (t6977 - s2714);
      t7000 = (s2707 + s2721);
      buf4((2 + a6527)) = (t6998 + t7000);
      buf4((10 + a6527)) = (t6998 - t7000);
      a6530 = (1.0i*(s2707 - s2721));
      buf4((6 + a6527)) = (t6999 + a6530);
      buf4((14 + a6527)) = (t6999 - a6530);
      t7001 = (t6979 + s2716);
      t7002 = (t6979 - s2716);
      t7003 = (s2709 + s2723);
      buf4((3 + a6527)) = (t7001 + t7003);
      buf4((11 + a6527)) = (t7001 - t7003);
      a6531 = (1.0i*(s2709 - s2723));
      buf4((7 + a6527)) = (t7002 + a6531);
      buf4((15 + a6527)) = (t7002 - a6531);
    }
    var a6556, t7020, t7021, t7022:complex;
    var a6555:int;
    t7020 = (buf4(0) + buf4(32));
    t7021 = (buf4(0) - buf4(32));
    t7022 = (buf4(16) + buf4(48));
    a6555 = (64*i4198);
    buf3(a6555) = (t7020 + t7022);
    buf3((a6555 + 32)) = (t7020 - t7022);
    a6556 = (1.0i*(buf4(16) - buf4(48)));
    buf3((16 + a6555)) = (t7021 + a6556);
    buf3((48 + a6555)) = (t7021 - a6556);
    for i4216 in 0..6 {
      var a6602, s2740, s2741, s2742, s2743, t7039, t7040, t7041:complex;
      var a6601, b920:int;
      a6601 = (4*i4216);
      s2740 = (dat7(a6601)*buf4((1 + i4216)));
      s2741 = (dat7((1 + a6601))*buf4((33 + i4216)));
      t7039 = (s2740 + s2741);
      t7040 = (s2740 - s2741);
      s2742 = (dat7((2 + a6601))*buf4((17 + i4216)));
      s2743 = (dat7((3 + a6601))*buf4((49 + i4216)));
      t7041 = (s2742 + s2743);
      b920 = ((64*i4198) + i4216);
      buf3((b920 + 1)) = (t7039 + t7041);
      buf3((b920 + 33)) = (t7039 - t7041);
      a6602 = (1.0i*(s2742 - s2743));
      buf3((b920 + 17)) = (t7040 + a6602);
      buf3((b920 + 49)) = (t7040 - a6602);
    }
    var s2748, s2749, t7058, t7059:complex;
    var a6632:int;
    t7058 = (buf4(8) + (1.0i*buf4(40)));
    t7059 = (buf4(8) + ((- 1.0i)*buf4(40)));
    s2748 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf4(24) + (1.0i*buf4(56))));
    s2749 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf4(24) + ((- 1.0i)*buf4(56))));
    a6632 = (64*i4198);
    buf3((8 + a6632)) = (t7058 + s2748);
    buf3((40 + a6632)) = (t7058 - s2748);
    buf3((24 + a6632)) = (t7059 + s2749);
    buf3((56 + a6632)) = (t7059 - s2749);
    for i4217 in 0..6 {
      var a6678, s2766, s2767, s2768, s2769, t7076, t7077, t7078:complex;
      var a6677, b926:int;
      a6677 = (4*i4217);
      s2766 = (dat8(a6677)*buf4((9 + i4217)));
      s2767 = (dat8((1 + a6677))*buf4((41 + i4217)));
      t7076 = (s2766 + s2767);
      t7077 = (s2766 - s2767);
      s2768 = (dat8((2 + a6677))*buf4((25 + i4217)));
      s2769 = (dat8((3 + a6677))*buf4((57 + i4217)));
      t7078 = (s2768 + s2769);
      b926 = ((64*i4198) + i4217);
      buf3((b926 + 9)) = (t7076 + t7078);
      buf3((b926 + 41)) = (t7076 - t7078);
      a6678 = (1.0i*(s2768 - s2769));
      buf3((b926 + 25)) = (t7077 + a6678);
      buf3((b926 + 57)) = (t7077 - a6678);
    }
  }
  var a6691, t7095, t7096, t7097:complex;
  t7095 = (buf3(0) + buf3(128));
  t7096 = (buf3(0) - buf3(128));
  t7097 = (buf3(64) + buf3(192));
  Y(0) = (t7095 + t7097);
  Y(128) = (t7095 - t7097);
  a6691 = (1.0i*(buf3(64) - buf3(192)));
  Y(64) = (t7096 + a6691);
  Y(192) = (t7096 - a6691);
  for i4196 in 0..30 {
    var a6732, s2786, s2787, s2788, s2789, t7114, t7115, t7116:complex;
    var a6727, a6728, a6729, a6730, a6731:int;
    a6727 = (1 + i4196);
    a6728 = (129 + i4196);
    a6729 = (4*i4196);
    s2786 = (dat5(a6729)*buf3(a6727));
    s2787 = (dat5((1 + a6729))*buf3(a6728));
    t7114 = (s2786 + s2787);
    t7115 = (s2786 - s2787);
    a6730 = (65 + i4196);
    a6731 = (193 + i4196);
    s2788 = (dat5((2 + a6729))*buf3(a6730));
    s2789 = (dat5((3 + a6729))*buf3(a6731));
    t7116 = (s2788 + s2789);
    Y(a6727) = (t7114 + t7116);
    Y(a6728) = (t7114 - t7116);
    a6732 = (1.0i*(s2788 - s2789));
    Y(a6730) = (t7115 + a6732);
    Y(a6731) = (t7115 - a6732);
  }
  var s2794, s2795, t7133, t7134:complex;
  t7133 = (buf3(32) + (1.0i*buf3(160)));
  t7134 = (buf3(32) + ((- 1.0i)*buf3(160)));
  s2794 = ((0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf3(96) + (1.0i*buf3(224))));
  s2795 = ((-0.70710678118654757 + 1.0i * 0.70710678118654757)*(buf3(96) + ((- 1.0i)*buf3(224))));
  Y(32) = (t7133 + s2794);
  Y(160) = (t7133 - s2794);
  Y(96) = (t7134 + s2795);
  Y(224) = (t7134 - s2795);
  for i4197 in 0..30 {
    var a6789, s2812, s2813, s2814, s2815, t7151, t7152, t7153:complex;
    var a6784, a6785, a6786, a6787, a6788:int;
    a6784 = (33 + i4197);
    a6785 = (161 + i4197);
    a6786 = (4*i4197);
    s2812 = (dat6(a6786)*buf3(a6784));
    s2813 = (dat6((1 + a6786))*buf3(a6785));
    t7151 = (s2812 + s2813);
    t7152 = (s2812 - s2813);
    a6787 = (97 + i4197);
    a6788 = (225 + i4197);
    s2814 = (dat6((2 + a6786))*buf3(a6787));
    s2815 = (dat6((3 + a6786))*buf3(a6788));
    t7153 = (s2814 + s2815);
    Y(a6784) = (t7151 + t7153);
    Y(a6785) = (t7151 - t7153);
    a6789 = (1.0i*(s2814 - s2815));
    Y(a6787) = (t7152 + a6789);
    Y(a6788) = (t7152 - a6789);
  }

}
