//This code is based on the XMT version of the Graph5000 benchmark submitted by
//John Feo <john.feo@pnl.gov> and Kristi Maschhoff <kristyn@cray.com> in 2010.

module Create_Parent_Tree
{
use Graph500_defs;

proc BFS ( root : vertex_id, ParentTree, G )
{

  type Vertex_List = domain ( vertex_id );
  var visited$ : [vertex_domain] sync int = -1;

  var Active_Level = new Level_Set (Vertex_List);
  var Next_Level = new Level_Set (Vertex_List);

// Lock currently needed as associative domain add is not thread safe

  var node_add_lock$ : sync bool = true;
  var Root_vertex : vertex_id = root;

  ParentTree[root] = root;
  Active_Level.Members.add ( Root_vertex );
  Next_Level.Members.clear ();

  visited$ (root).writeFF(1);
  Active_Level.previous = nil;
  Next_Level.previous = Active_Level;

  while Active_Level.Members.numIndices > 0 do
  {

    forall u in Active_Level.Members do {

      forall v in G.Neighbors (u) do {

        if ( visited$ (v).readXX() < 0 ) 
        {
          if (visited$ (v).readFE() < 0 )
          {
              visited$ (v).writeEF (1);
              node_add_lock$.readFE();
              Next_Level.Members.add (v);
              node_add_lock$.writeEF (true);
              ParentTree (v) = u;
          }
          else
          {
              visited$ (v).writeEF(1);
          }
        }
      }
    }

//    writeln("Active Level is ",Active_Level);

    Active_Level = Next_Level;
    Next_Level = new Level_Set (Vertex_List);

    Next_Level.Members.clear ();
    Next_Level.previous = Active_Level;

  }
//  writeln("Active Level is ",Active_Level);
}


}



