/*
 * Copyright 2016 Cray Inc.
 * Other additional copyright holders may be indicated within.
 *
 * The entirety of this work is licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Events generated by the runtime and VisualDebug.chpl

#include "Event.h"

bool operator < (Event &lh, Event &rh)
{
  if (lh.tsec() < rh.tsec()) return true;
  if (lh.tsec() == rh.tsec() && lh.tusec() < rh.tusec()) return true;
  return false;
}

bool operator == (Event &lh, Event &rh)
{
  return lh.tsec() == rh.tsec() && lh.tusec() == rh.tusec();
}
