/*
 * Copyright 2004-2016 Cray Inc.
 * Other additional copyright holders may be indicated within.
 * 
 * The entirety of this work is licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * 
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// chplcgfns.h
//
// Declarations for variables and prototypes for functions which are
// generated by the chapel compiler.
// This header makes those symbols available to client code in the runtime.
//
// TODO: Arguably, since it contains both function and variable declarations,
//  it should be renamed as chplcgdecl.h (or so).
//
#ifndef _CHPL_GEN_INTERFACE_H_
#define _CHPL_GEN_INTERFACE_H_

#include <stddef.h>
#include <stdlib.h>

#include "chpltypes.h"

/* This header file is for routines that are in the generated code */

/* defined in chpl_compilation_config.c: */
extern const char* chpl_compileCommand;
extern const char* chpl_compileVersion;
extern const char* CHPL_HOME;
extern const char* CHPL_HOST_PLATFORM;
extern const char* CHPL_HOST_COMPILER;
extern const char* CHPL_TARGET_PLATFORM;
extern const char* CHPL_TARGET_COMPILER;
extern const char* CHPL_TARGET_ARCH;
extern const char* CHPL_LOCALE_MODEL;
extern const char* CHPL_COMM;
extern const char* CHPL_COMM_SUBSTRATE;
extern const char* CHPL_GASNET_SEGMENT;
extern const char* CHPL_TASKS;
extern const char* CHPL_LAUNCHER;
extern const char* CHPL_TIMERS;
extern const char* CHPL_MEM;
extern const char* CHPL_MAKE;
extern const char* CHPL_ATOMICS;
extern const char* CHPL_NETWORK_ATOMICS;
extern const char* CHPL_GMP;
extern const char* CHPL_HWLOC;
extern const char* CHPL_REGEXP;
extern const char* CHPL_WIDE_POINTERS;
extern const char* CHPL_LLVM;
extern const char* CHPL_AUX_FILESYS;
extern const int CHPL_STACK_CHECKS;
extern const int CHPL_CACHE_REMOTE;

// Sorted lookup table of filenames used with insertLineNumbers for error
// messages and logging. Defined in chpl_compilation_config.c (needed by launchers)
extern c_string chpl_filenameTable[];
extern const int32_t chpl_filenameTableSize;

/* defined in main.c */
extern char* chpl_executionCommand;

/* generated */
extern chpl_fn_p chpl_ftable[];

extern void chpl__initStringLiterals(void);


void chpl__init_preInit(int64_t _ln, int32_t _fn);
void chpl__init_PrintModuleInitOrder(int64_t _ln, int32_t _fn);
void chpl__init_ChapelStandard(int64_t _ln, int32_t _fn);

/* used for entry point: */
extern int64_t chpl_gen_main(chpl_main_argument* const _arg);

/* used for config vars: */
extern void CreateConfigVarTable(void);

/* used by copy collection: */

//extern size_t cid2size(chpl__class_id cid);
//extern size_t* cid2offsets(chpl__class_id cid);

/* These are defined in _type_structure.c if
   --gen-communicated-structures is true and are used by a
   communication layer to query types of communicated buffers */
extern chplType chpl_getFieldType(int typeNum, int fieldNum);
extern size_t chpl_getFieldOffset(int typeNum, int fieldNum);
extern size_t chpl_getFieldSize(int typeNum);
extern const int chpl_max_fields_per_type;

#endif
