/*
 * Copyright 2004-2016 Cray Inc.
 * Other additional copyright holders may be indicated within.
 *
 * The entirety of this work is licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 *
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _IPE_SCOPE_BLOCK_H_
#define _IPE_SCOPE_BLOCK_H_

#include "IpeScope.h"

class IpeModule;

class IpeScopeBlock : public IpeScope
{
public:
                           IpeScopeBlock(IpeScope* parent);
  virtual                 ~IpeScopeBlock();

  virtual const char*      type()                                     const;
  virtual const char*      name()                                     const;

  virtual int              locationSet(ArgSymbol* arg)                const;
  virtual int              locationSet(VarSymbol* var)                const;

  virtual int              frameSize()                                const;

  virtual bool             isScopeBlockStmt()                         const;

private:
                           IpeScopeBlock();
};

#endif
