#!/bin/bash
# This script accepts no arguments and automates the process of updating
# Certbot's dependencies including automatically updating the correct file.
# Dependencies can be pinned to older versions by modifying pyproject.toml in
# the same directory as this file.
set -euo pipefail

WORK_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null && pwd )"
COMMON_DIR="$(dirname "${WORK_DIR}")/common"
REPO_ROOT="$(git rev-parse --show-toplevel)"
RELATIVE_SCRIPT_PATH="$(realpath --relative-to "$REPO_ROOT" "$WORK_DIR")/$(basename "${BASH_SOURCE[0]}")"
CONSTRAINTS_FILE="$REPO_ROOT/tools/oldest_constraints.txt"

PINNINGS=$("${COMMON_DIR}/export-pinned-dependencies.sh" "${WORK_DIR}")
cat << EOF > "$CONSTRAINTS_FILE"
# This file was generated by $RELATIVE_SCRIPT_PATH and can be updated using
# that script.
EOF
echo "${PINNINGS}" >> "${CONSTRAINTS_FILE}"
