/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2014 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            K.U. Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


#ifndef CASADI_GET_ELEMENTS_HPP
#define CASADI_GET_ELEMENTS_HPP

#include "mx_node.hpp"
#include <map>
#include <stack>

/// \cond INTERNAL

namespace casadi {
  /** \brief Get elements of a matrix given an index matrix
      \author Joel Andersson
      \date 2017
  */
  class CASADI_EXPORT GetElements : public MXNode {
    /// Constructor
    GetElements(const MX& ind, const MX& x);
  public:
    ///@{
    /// Create functions
    static MX create(const MX& ind, const MX& x);
    ///@}

    /// Destructor
    ~GetElements() override {}

    /** \brief  Print expression */
    std::string disp(const std::vector<std::string>& arg) const override;

    /** \brief Get the operation */
    int op() const override { return OP_GET_ELEMENTS;}

    /// Can the operation be performed inplace (i.e. overwrite the result)
    int n_inplace() const override { return 1;}

    /// Evaluate the function numerically
    int eval(const double** arg, double** res, int* iw, double* w) const override;
  };

} // namespace casadi
/// \endcond

#endif // CASADI_GET_ELEMENTS_HPP
