var tipuesearch = {"pages":[{"title":" cafut ","text":"cafut The point of this library is to provide a simple, object-oriented unit testing framework meant for applications using Coarray Fortran. As it is further developped, we place more importance in brevity than to features, and for that reason, this project aims at maintaining all code within a single module that can be placed with the tested scripts. Other unit testing frameworks for Fortran (that I know of) give unorganized outputs when the program is meant to run in parallel using Coarrays. This ultimately comes down to coordinating test results amongst images such that test summaries are more organized and informative when it comes to the results of each image. Workarounds that revolve around adapting tests to immitate parallel behavior will run slower and everything else that made you want to write a parallel program in the first place. Setup To use cafut to its fullest, your compiler must have implemented Fortran Coarrays. In the examples shown bellow, I will be using OpenCoarrays , though there are several other options available. If you wish to compile cafut for testing with a single image (such as using cafut for sequential programs), you can add the -fcoarray=single flag to gcc in order to compile the program. Quick and Dirty If you want to use cafut for some quick tests on a specific file, start by cloning cafut and generating the necessary .mod file with: git clone https://github.com/renatomatz/cafut.git cd cafut/src/\ncaf -c cafut.f90 where caf is the OpenCoarray compiler for using cafut with multiple images. Then, just add the cafut.mod file, which should be an output from the above command, to the same directory that the program you wish to test is located. To use cafut, simply add use cafut to the test program. Fortran Package Manager (fpm) To use cafut for testing in your fpm project without making it a build dependency, just add the following to your package manifest file ( fpm.toml ) under the relevant test descriptions (which in the example bellow, we call main ): [[ test ]] name = \"main\" source-dir = \"test/\" main = \"main.f90\" [test.dependencies] cafut = { git = \"https://github.com/renatomatz/cafut.git\" } You can then use the package in your testing programs with use cafut . Examples This framework centers around creating a linked list of unit tests. The two principal objects of the framework are the TestSuite , which is the first node of the linked list, and types extending the Test abstract type, which are the nodes of the list. In other words, the TestSuite type contains any number of Test objects, which it will execute and collect data from. To create a new test suite, simply instanciate a TestSuite object, giving it an appropriate name. ts = TestSuite ( \"TEST 1\" ) There are two ways to add new tests to a TestSuite object. One is to create and set up a Test instance externally and then add said the instance to the test suite. trv = TestRealVal ( \"subtest 1.2\" ) trv % res = 1. + 1. trv % tgt = 2. call ts % add ( trv ) The other is to add a test directly into the test suite by using one of the subroutines linked to the add generic procedure. To do this, just specify the new Test instance (which must be constructed with a name) as the first argument to the add procedure followed by the required arguments. call ts % add ( TestRealVal ( \"subtest 1.1\" ), 1. + 1. , 2. ) NOTE that tests which involve arrays which are created externally must allocate the relevant attributes externally as well. trav = TestRealArrVal ( \"subtest 1.3\" ) allocate ( trav % res ( 2 ), trav % tgt ( 2 )) trav2 % res = [ 1. , 1. ] trav2 % tgt = [ 2. , 2. ] call ts % add ( trav ) Developer Info Renato Zimmermann","tags":"home","loc":"index.html"},{"title":"cafut.f90 – cafut","text":"Contents Modules cafut Source Code cafut.f90 Source Code module cafut use iso_fortran_env , only : real64 implicit none !> Define real number kind. integer , private , parameter :: wp = real64 !> Define maximum name length. integer , private , parameter :: NAME_LENGTH = 20 !> Define margin of floating point error for real value comparissons. real ( kind = real64 ), private , parameter :: default_eps = 1.0d-5 !> Format of the start of a unit test. character ( len =* ), private , parameter :: TEST_START = & '(\"==================== \", A, \" ====================\")' !> Format of the end of a unit test. character ( len =* ), private , parameter :: TEST_END = & '(A, \" FINISHED WITH \", I3, \"/\", I3, \" TESTS PASSED\")' !> Format of the start of a unit test. character ( len =* ), private , parameter :: SUBTEST_START = & '(\"> \", A20)' !> Format of the end of a unit test. character ( len =* ), private , parameter :: SUBTEST_END = & '(\"finished with\" , I3, \"/\", I3, \" images passed\")' !> Format of the failure description of an image comparing real values. character ( len =* ), private , parameter :: SINGLE_VAL_FMT = & '(\">> TEST FAILED | Image: \", I3, \" | Got: \", F10.5, \" | Expected: \", F10.5)' !> Format of the header for a failed test of an image comparring arrays. character ( len =* ), private , parameter :: ARR_VAL_IMG = & '(\">> Image: \", I3)' !> String preceeding result array. character ( len =* ), private , parameter :: ARR_VAL_RES = & \">>> Got: \" !> String preceeding expected array. character ( len =* ), private , parameter :: ARR_VAL_EXP = & \">>> Expected: \" type , public :: TestSuite !! Holds tests and manages their executtion. !! Represents a set of procedures to test a certain feature. !! First node of the test linked list. integer , private :: n_tests !! Number of tests in a test suite. character ( len = NAME_LENGTH ), private :: test_suite_name !! Name of the test suite. class ( Test ), public , pointer :: test !! Current test whose attributes are available to be set. contains procedure , public , pass :: addUnitTest procedure , private , pass :: addTestRealVal procedure , private , pass :: addTestRealArrVal generic , public :: add => addUnitTest , addTestRealVal , addTestRealArrVal procedure , public , pass :: runTests final :: deleteTestSuite end type TestSuite interface TestSuite !! Constructor interface for a TestSuite object. module procedure newTestSuite end interface TestSuite type , abstract , private :: Test !! Abstract class for a single test case. A node in the test linked list. character ( len = NAME_LENGTH ), public :: test_name !! Name of the test case. class ( Test ), private , pointer :: next !! Next test case or null() if this is the first test inserted (last !! test in the linked list). contains procedure ( runInterface ), deferred , pass :: run end type Test abstract interface function runInterface ( self ) result ( tests_passed ) !! Abstract function interface for running a test. import Test class ( Test ), intent ( in ) :: self !! The test itself. The Test object should contain all information !! needed to run the test. integer :: tests_passed !! Return total number of tests which passed in the linked list !! up to and including this test. end function runInterface end interface type , public , extends ( Test ) :: TestRealVal !! Test performed on single real values. procedure ( realCompInterface ), public , nopass , pointer :: compare !! Pointer to a comparisson function used to perform the test. real ( kind = wp ), private :: eps !! Allowed margin of error between real numbers real ( kind = wp ), public :: res !! Real value result from some process. real ( kind = wp ), public :: tgt !! Target real value result for some process. contains procedure , public , pass :: run => runTestRealVal procedure , private , nopass :: printFail => printFailTestRealVal final :: deleteTestRealVal end type TestRealVal interface TestRealVal !! Constructor interface for a TestRealVal object. module procedure newTestRealVal_name end interface TestRealVal interface function realCompInterface ( res , tgt , eps ) result ( comp ) !! Abstract function interface for a value comparisson function. import wp real ( kind = wp ), intent ( in ) :: res !! Result being tested. real ( kind = wp ), intent ( in ) :: tgt !! Target value used to compare result to. real ( kind = wp ) :: eps !! Allowed margin of error logical :: comp !! Return whether or not the test succeeded based on a comparrison. end function realCompInterface end interface type , public , extends ( Test ) :: TestRealArrVal !! Test performed on an array of real values. procedure ( realArrCompInterface ), nopass , pointer :: compare !! Pointer to a comparisson function used to perform the test. real ( kind = wp ), private :: eps !! Allowed margin of error between real numbers real ( kind = wp ), public , allocatable , dimension (:) :: res !! Real array result from some process. real ( kind = wp ), public , allocatable , dimension (:) :: tgt !! Target real array result for some process. contains procedure , public , pass :: run => runTestRealArrVal procedure , private , nopass :: printFail => printFailTestRealArrVal final :: deleteTestRealArrVal end type TestRealArrVal interface TestRealArrVal !! Constructor interface for a TestRealArrVal object. module procedure newTestRealArrVal_name end interface TestRealArrVal interface function realArrCompInterface ( res , tgt , eps ) result ( comp ) !! Abstract function interface for an array comparisson function. import wp real ( kind = wp ), dimension (:), intent ( in ) :: res , tgt !! See res and tgt in TestRealArrVal class. real ( kind = wp ) :: eps !! Allowed margin of error logical :: comp !! Return whether or not the test succeeded based on a comparrison. end function realArrCompInterface end interface contains ! TestSuite ! ========= function newTestSuite ( ts_name ) result ( new_ts ) !! Construct a new test suite. character ( len =* ), intent ( in ) :: ts_name !! Name of the test suite. type ( TestSuite ) :: new_ts !! Return the new test suite. new_ts % n_tests = 0 new_ts % test => null () new_ts % test_suite_name = ts_name end function newTestSuite subroutine deleteTestSuite ( self ) !! Destruct a test suite by deallocating its test pointer attribute. type ( TestSuite ), intent ( inout ) :: self deallocate ( self % test ) end subroutine deleteTestSuite subroutine runTests ( self ) !! Run all tests contained in a test suite. class ( TestSuite ), intent ( in ) :: self integer :: tot_passed if ( this_image () == 1 ) then print TEST_START , trim ( self % test_suite_name ) end if tot_passed = 0 if ( associated ( self % test )) tot_passed = self % test % run () if ( this_image () == 1 ) then print TEST_END , trim ( self % test_suite_name ), tot_passed , self % n_tests end if end subroutine runTests subroutine addUnitTest ( self , ut ) !! Add a Test object to the test suite and make it available for setup. class ( TestSuite ), intent ( inout ) :: self class ( Test ), target , intent ( inout ) :: ut !! Object derived from the Test abstract type. class ( Test ), pointer :: next if ( this_image () == 1 ) self % n_tests = self % n_tests + 1 if ( associated ( self % test )) allocate ( next , source = self % test ) next => self % test ut % next => next self % test => ut end subroutine addUnitTest subroutine addTestRealVal ( self , ut , res , tgt ) !! Compact alternative to add a TestRealVal object to the test suite. class ( TestSuite ), intent ( inout ) :: self type ( TestRealVal ), intent ( in ) :: ut !! An initialized TestRealVal object with the desired name. real ( kind = wp ), intent ( in ) :: res , tgt !! See TestRealVal. class ( Test ), pointer :: next if ( this_image () == 1 ) self % n_tests = self % n_tests + 1 if ( associated ( self % test )) allocate ( next , source = self % test ) next => self % test allocate ( self % test , source = ut ) associate ( t => self % test ) select type ( t ) type is ( TestRealVal ) t % next => next t % test_name = ut % test_name t % res = res t % tgt = tgt end select end associate end subroutine addTestRealVal subroutine addTestRealArrVal ( self , ut , res , tgt ) !! Compact alternative to add a TestRealArrVal object to the test suite. class ( TestSuite ), intent ( inout ) :: self type ( TestRealArrVal ), intent ( in ) :: ut !! An initialized TestRealArrVal object with the desired name. real ( kind = wp ), allocatable , dimension (:) :: res , tgt !! See TestRealArrVal. class ( Test ), pointer :: next if ( this_image () == 1 ) self % n_tests = self % n_tests + 1 if ( associated ( self % test )) allocate ( next , source = self % test ) next => self % test allocate ( self % test , source = ut ) associate ( t => self % test ) select type ( t ) type is ( TestRealArrVal ) t % next => next t % test_name = ut % test_name t % res = res t % tgt = tgt end select end associate end subroutine addTestRealArrVal ! Test ! ==== ! Comparison Functions function realEq ( res , tgt , eps ) result ( comp ) !! Test if two real values are equal. Uses an epsilon value to account !! for floating point error. real ( kind = wp ), intent ( in ) :: res !! Real value result being tested. real ( kind = wp ), intent ( in ) :: tgt !! Target real value to compare result to. real ( kind = wp ) :: eps !! Allowed margin of error logical :: comp !! Return whether both values are equal. comp = abs ( res - tgt ) < eps end function realEq function realArrEq ( res , tgt , eps ) result ( comp ) !! Test if two real arrays are _exactly_ equal. Arrays must be of the !! same length and have the same values in the same positions. Uses !! epsilon value to account for floating point error. real ( kind = wp ), dimension (:), intent ( in ) :: res !! Real value result being tested. real ( kind = wp ), dimension (:), intent ( in ) :: tgt !! Target real value to compare result to. real ( kind = wp ) :: eps !! Allowed margin of error logical :: comp if ( size ( res ) /= size ( tgt )) then comp = . false . return end if comp = all ( abs ( res - tgt ) < eps ) end function realArrEq ! Constructors function newTestRealVal_name ( ts_name , eps ) result ( new_ts ) !! Construct new TestRealVal given a name. character ( len =* ), intent ( in ) :: ts_name !! Name of the new TestRealVal object. real ( kind = wp ), optional :: eps !! Allowed margin of error type ( TestRealVal ) :: new_ts !! Return new TestRealVal object. new_ts % test_name = ts_name if ( present ( eps )) then new_ts % eps = eps else new_ts % eps = default_eps end if new_ts % next => null () new_ts % compare => realEq !TODO: create a bunch of subclasses with different comparisson ! operators. new_ts % res = 0 new_ts % tgt = 0 end function newTestRealVal_name function newTestRealArrVal_name ( ts_name , eps ) result ( new_ts ) !! Construct new TestRealArrVal given a name. character ( len =* ), intent ( in ) :: ts_name !! Name of the new TestRealArrVal object. real ( kind = wp ), optional :: eps !! Allowed margin of error type ( TestRealArrVal ) :: new_ts !! Return new TestRealArrVal object. new_ts % test_name = ts_name if ( present ( eps )) then new_ts % eps = eps else new_ts % eps = default_eps end if new_ts % next => null () new_ts % compare => realArrEq !TODO: create a bunch of subclasses with different comparisson ! operators. end function newTestRealArrVal_name ! Destructors subroutine deleteTestRealVal ( self ) !! Destruct TestRealVal object by deallocating its next object pointer. type ( TestRealVal ), intent ( inout ) :: self deallocate ( self % next ) end subroutine deleteTestRealVal subroutine deleteTestRealArrVal ( self ) !! Destruct TestRealVal object by deallocating its next object pointer !! as well as its res and tgt arrays. type ( TestRealArrVal ), intent ( inout ) :: self deallocate ( self % next ) deallocate ( self % res ) deallocate ( self % tgt ) end subroutine deleteTestRealArrVal ! Print Fail Functions subroutine printFailTestRealVal ( img , res , tgt ) !! Print failure message of a real value comparrison. integer , intent ( in ) :: img !! Image where the failure occured. real ( kind = wp ), intent ( in ) :: res !! (Incorrect) result value of some procedure. real ( kind = wp ), intent ( in ) :: tgt !! (Correct) target result value of some procedure. print SINGLE_VAL_FMT , img , res , tgt end subroutine printFailTestRealVal subroutine printFailTestRealArrVal ( img , res , tgt ) !! Print failure message of a real array comparrison. integer , intent ( in ) :: img !! Image where the failure occured. real ( kind = wp ), dimension (:), intent ( in ) :: res !! (Incorrect) result array of some procedure. real ( kind = wp ), dimension (:), intent ( in ) :: tgt !! (Correct) target result array of some procedure. print ARR_VAL_IMG , img print '(A)' , ARR_VAL_RES print * , res print '(A)' , ARR_VAL_EXP print * , tgt end subroutine printFailTestRealArrVal ! Run Functions function runTestRealVal ( self ) result ( tests_passed ) !! Run test on real values and print summary report for images. class ( TestRealVal ), intent ( in ) :: self integer :: tests_passed !! Return the tests that passed up to and including this one in !! the linked list. real ( kind = wp ), allocatable , codimension [:] :: res , tgt integer :: img_passed , i if ( associated ( self % next )) then tests_passed = self % next % run () else tests_passed = 0 end if allocate ( res [ * ], tgt [ * ]) res = self % res tgt = self % tgt sync all img_passed = 0 if ( this_image () == 1 ) then print SUBTEST_START , self % test_name do i = 1 , num_images () if ( self % compare ( res [ i ], tgt [ i ], self % eps )) then img_passed = img_passed + 1 else call self % printFail ( i , res [ i ], tgt [ i ]) end if end do print SUBTEST_END , img_passed , num_images () end if if ( img_passed == num_images ()) tests_passed = tests_passed + 1 end function runTestRealVal function runTestRealArrVal ( self ) result ( tests_passed ) !! Run test on real arrays and print summary report for images. class ( TestRealArrVal ), intent ( in ) :: self integer :: tests_passed !! Return the tests that passed up to and including this one in !! the linked list. real ( kind = wp ), allocatable , dimension (:), codimension [:] :: res , tgt integer , allocatable , codimension [:] :: res_n , tgt_n integer :: max_res_n , max_tgt_n integer :: img_passed , i if ( associated ( self % next )) then tests_passed = self % next % run () else tests_passed = 0 end if allocate ( res_n [ * ], tgt_n [ * ]) res_n = size ( self % res ) tgt_n = size ( self % tgt ) max_res_n = res_n call co_max ( max_res_n ) max_tgt_n = tgt_n call co_max ( max_tgt_n ) allocate ( res ( max_res_n )[ * ], tgt ( max_tgt_n )[ * ]) res (: res_n ) = self % res tgt (: res_n ) = self % tgt sync all img_passed = 0 if ( this_image () == 1 ) then print SUBTEST_START , self % test_name do i = 1 , num_images () if ( self % compare ( res (: res_n [ i ])[ i ], tgt (: tgt_n [ i ])[ i ], self % eps )) then img_passed = img_passed + 1 else call self % printFail ( i , res (: res_n [ i ])[ i ], tgt (: tgt_n [ i ])[ i ]) end if end do print SUBTEST_END , img_passed , num_images () end if if ( img_passed == num_images ()) tests_passed = tests_passed + 1 deallocate ( res_n , tgt_n , res , tgt ) end function runTestRealArrVal end module cafut","tags":"","loc":"sourcefile/cafut.f90.html"},{"title":"Test – cafut ","text":"type, public, abstract :: Test Abstract class for a single test case. A node in the test linked list. Contents Variables test_name Type-Bound Procedures run Source Code Test Components Type Visibility Attributes Name Initial character(len=NAME_LENGTH), public :: test_name Name of the test case. Type-Bound Procedures procedure( runInterface ), public, deferred, pass :: run function runInterface(self) result(tests_passed) Prototype Abstract function interface for running a test. Arguments Type Intent Optional Attributes Name class( Test ), intent(in) :: self The test itself. The Test object should contain all information\nneeded to run the test. Return Value integer Return total number of tests which passed in the linked list\nup to and including this test. Source Code type , abstract , private :: Test !! Abstract class for a single test case. A node in the test linked list. character ( len = NAME_LENGTH ), public :: test_name !! Name of the test case. class ( Test ), private , pointer :: next !! Next test case or null() if this is the first test inserted (last !! test in the linked list). contains procedure ( runInterface ), deferred , pass :: run end type Test","tags":"","loc":"type/test.html"},{"title":"TestRealArrVal – cafut ","text":"type, public, extends( Test ) :: TestRealArrVal Test performed on an array of real values. Contents Variables compare res test_name tgt Constructor TestRealArrVal Finalization Procedures deleteTestRealArrVal Type-Bound Procedures run Source Code TestRealArrVal Components Type Visibility Attributes Name Initial procedure( realArrCompInterface ), public, nopass, pointer :: compare Pointer to a comparisson function used to perform the test. real(kind=wp), public, allocatable, dimension(:) :: res Real array result from some process. character(len=NAME_LENGTH), public :: test_name Name of the test case. real(kind=wp), public, allocatable, dimension(:) :: tgt Target real array result for some process. Constructor public interface TestRealArrVal Constructor interface for a TestRealArrVal object. public function newTestRealArrVal_name (ts_name, eps) result(new_ts) Construct new TestRealArrVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealArrVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealArrVal ) Return new TestRealArrVal object. Finalization Procedures final :: deleteTestRealArrVal public subroutine deleteTestRealArrVal (self) Destruct TestRealVal object by deallocating its next object pointer\nas well as its res and tgt arrays. Arguments Type Intent Optional Attributes Name type( TestRealArrVal ), intent(inout) :: self Type-Bound Procedures procedure, public, pass :: run => runTestRealArrVal public function runTestRealArrVal (self) result(tests_passed) Run test on real arrays and print summary report for images. Arguments Type Intent Optional Attributes Name class( TestRealArrVal ), intent(in) :: self Return Value integer Return the tests that passed up to and including this one in\nthe linked list. Source Code type , public , extends ( Test ) :: TestRealArrVal !! Test performed on an array of real values. procedure ( realArrCompInterface ), nopass , pointer :: compare !! Pointer to a comparisson function used to perform the test. real ( kind = wp ), private :: eps !! Allowed margin of error between real numbers real ( kind = wp ), public , allocatable , dimension (:) :: res !! Real array result from some process. real ( kind = wp ), public , allocatable , dimension (:) :: tgt !! Target real array result for some process. contains procedure , public , pass :: run => runTestRealArrVal procedure , private , nopass :: printFail => printFailTestRealArrVal final :: deleteTestRealArrVal end type TestRealArrVal","tags":"","loc":"type/testrealarrval.html"},{"title":"TestRealVal – cafut ","text":"type, public, extends( Test ) :: TestRealVal Test performed on single real values. Contents Variables compare res test_name tgt Constructor TestRealVal Finalization Procedures deleteTestRealVal Type-Bound Procedures run Source Code TestRealVal Components Type Visibility Attributes Name Initial procedure( realCompInterface ), public, nopass, pointer :: compare Pointer to a comparisson function used to perform the test. real(kind=wp), public :: res Real value result from some process. character(len=NAME_LENGTH), public :: test_name Name of the test case. real(kind=wp), public :: tgt Target real value result for some process. Constructor public interface TestRealVal Constructor interface for a TestRealVal object. public function newTestRealVal_name (ts_name, eps) result(new_ts) Construct new TestRealVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealVal ) Return new TestRealVal object. Finalization Procedures final :: deleteTestRealVal public subroutine deleteTestRealVal (self) Destruct TestRealVal object by deallocating its next object pointer. Arguments Type Intent Optional Attributes Name type( TestRealVal ), intent(inout) :: self Type-Bound Procedures procedure, public, pass :: run => runTestRealVal public function runTestRealVal (self) result(tests_passed) Run test on real values and print summary report for images. Arguments Type Intent Optional Attributes Name class( TestRealVal ), intent(in) :: self Return Value integer Return the tests that passed up to and including this one in\nthe linked list. Source Code type , public , extends ( Test ) :: TestRealVal !! Test performed on single real values. procedure ( realCompInterface ), public , nopass , pointer :: compare !! Pointer to a comparisson function used to perform the test. real ( kind = wp ), private :: eps !! Allowed margin of error between real numbers real ( kind = wp ), public :: res !! Real value result from some process. real ( kind = wp ), public :: tgt !! Target real value result for some process. contains procedure , public , pass :: run => runTestRealVal procedure , private , nopass :: printFail => printFailTestRealVal final :: deleteTestRealVal end type TestRealVal","tags":"","loc":"type/testrealval.html"},{"title":"TestSuite – cafut ","text":"type, public :: TestSuite Holds tests and manages their executtion.\nRepresents a set of procedures to test a certain feature.\nFirst node of the test linked list. Contents Variables test Constructor TestSuite Finalization Procedures deleteTestSuite Type-Bound Procedures add addUnitTest runTests Source Code TestSuite Components Type Visibility Attributes Name Initial class( Test ), public, pointer :: test Current test whose attributes are available to be set. Constructor public interface TestSuite Constructor interface for a TestSuite object. public function newTestSuite (ts_name) result(new_ts) Construct a new test suite. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the test suite. Return Value type( TestSuite ) Return the new test suite. Finalization Procedures final :: deleteTestSuite public subroutine deleteTestSuite (self) Destruct a test suite by deallocating its test pointer attribute. Arguments Type Intent Optional Attributes Name type( TestSuite ), intent(inout) :: self Type-Bound Procedures generic, public :: add => addUnitTest , addTestRealVal, addTestRealArrVal public subroutine addUnitTest (self, ut) Add a Test object to the test suite and make it available for setup. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self class( Test ), intent(inout), target :: ut Object derived from the Test abstract type. public subroutine addTestRealVal (self, ut, res, tgt) Compact alternative to add a TestRealVal object to the test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self type( TestRealVal ), intent(in) :: ut An initialized TestRealVal object with the desired name. real(kind=wp), intent(in) :: res See TestRealVal. real(kind=wp), intent(in) :: tgt See TestRealVal. public subroutine addTestRealArrVal (self, ut, res, tgt) Compact alternative to add a TestRealArrVal object to the test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self type( TestRealArrVal ), intent(in) :: ut An initialized TestRealArrVal object with the desired name. real(kind=wp), allocatable, dimension(:) :: res See TestRealArrVal. real(kind=wp), allocatable, dimension(:) :: tgt See TestRealArrVal. procedure, public, pass :: addUnitTest public subroutine addUnitTest (self, ut) Add a Test object to the test suite and make it available for setup. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self class( Test ), intent(inout), target :: ut Object derived from the Test abstract type. procedure, public, pass :: runTests public subroutine runTests (self) Run all tests contained in a test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(in) :: self Source Code type , public :: TestSuite !! Holds tests and manages their executtion. !! Represents a set of procedures to test a certain feature. !! First node of the test linked list. integer , private :: n_tests !! Number of tests in a test suite. character ( len = NAME_LENGTH ), private :: test_suite_name !! Name of the test suite. class ( Test ), public , pointer :: test !! Current test whose attributes are available to be set. contains procedure , public , pass :: addUnitTest procedure , private , pass :: addTestRealVal procedure , private , pass :: addTestRealArrVal generic , public :: add => addUnitTest , addTestRealVal , addTestRealArrVal procedure , public , pass :: runTests final :: deleteTestSuite end type TestSuite","tags":"","loc":"type/testsuite.html"},{"title":"runInterface – cafut","text":"abstract interface public function runInterface(self) result(tests_passed) Arguments Type Intent Optional Attributes Name class( Test ), intent(in) :: self The test itself. The Test object should contain all information\nneeded to run the test. Return Value integer Return total number of tests which passed in the linked list\nup to and including this test. Description Abstract function interface for running a test.","tags":"","loc":"interface/runinterface.html"},{"title":"newTestRealArrVal_name – cafut","text":"public function newTestRealArrVal_name(ts_name, eps) result(new_ts) Construct new TestRealArrVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealArrVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealArrVal ) Return new TestRealArrVal object. Contents Source Code newTestRealArrVal_name Source Code function newTestRealArrVal_name ( ts_name , eps ) result ( new_ts ) !! Construct new TestRealArrVal given a name. character ( len =* ), intent ( in ) :: ts_name !! Name of the new TestRealArrVal object. real ( kind = wp ), optional :: eps !! Allowed margin of error type ( TestRealArrVal ) :: new_ts !! Return new TestRealArrVal object. new_ts % test_name = ts_name if ( present ( eps )) then new_ts % eps = eps else new_ts % eps = default_eps end if new_ts % next => null () new_ts % compare => realArrEq !TODO: create a bunch of subclasses with different comparisson ! operators. end function newTestRealArrVal_name","tags":"","loc":"proc/newtestrealarrval_name.html"},{"title":"newTestRealVal_name – cafut","text":"public function newTestRealVal_name(ts_name, eps) result(new_ts) Construct new TestRealVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealVal ) Return new TestRealVal object. Contents Source Code newTestRealVal_name Source Code function newTestRealVal_name ( ts_name , eps ) result ( new_ts ) !! Construct new TestRealVal given a name. character ( len =* ), intent ( in ) :: ts_name !! Name of the new TestRealVal object. real ( kind = wp ), optional :: eps !! Allowed margin of error type ( TestRealVal ) :: new_ts !! Return new TestRealVal object. new_ts % test_name = ts_name if ( present ( eps )) then new_ts % eps = eps else new_ts % eps = default_eps end if new_ts % next => null () new_ts % compare => realEq !TODO: create a bunch of subclasses with different comparisson ! operators. new_ts % res = 0 new_ts % tgt = 0 end function newTestRealVal_name","tags":"","loc":"proc/newtestrealval_name.html"},{"title":"newTestSuite – cafut","text":"public function newTestSuite(ts_name) result(new_ts) Construct a new test suite. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the test suite. Return Value type( TestSuite ) Return the new test suite. Contents Source Code newTestSuite Source Code function newTestSuite ( ts_name ) result ( new_ts ) !! Construct a new test suite. character ( len =* ), intent ( in ) :: ts_name !! Name of the test suite. type ( TestSuite ) :: new_ts !! Return the new test suite. new_ts % n_tests = 0 new_ts % test => null () new_ts % test_suite_name = ts_name end function newTestSuite","tags":"","loc":"proc/newtestsuite.html"},{"title":"realArrEq – cafut","text":"public function realArrEq(res, tgt, eps) result(comp) Test if two real arrays are exactly equal. Arrays must be of the\nsame length and have the same values in the same positions. Uses\nepsilon value to account for floating point error. Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in), dimension(:) :: res Real value result being tested. real(kind=wp), intent(in), dimension(:) :: tgt Target real value to compare result to. real(kind=wp) :: eps Allowed margin of error Return Value logical Contents Source Code realArrEq Source Code function realArrEq ( res , tgt , eps ) result ( comp ) !! Test if two real arrays are _exactly_ equal. Arrays must be of the !! same length and have the same values in the same positions. Uses !! epsilon value to account for floating point error. real ( kind = wp ), dimension (:), intent ( in ) :: res !! Real value result being tested. real ( kind = wp ), dimension (:), intent ( in ) :: tgt !! Target real value to compare result to. real ( kind = wp ) :: eps !! Allowed margin of error logical :: comp if ( size ( res ) /= size ( tgt )) then comp = . false . return end if comp = all ( abs ( res - tgt ) < eps ) end function realArrEq","tags":"","loc":"proc/realarreq.html"},{"title":"realEq – cafut","text":"public function realEq(res, tgt, eps) result(comp) Test if two real values are equal. Uses an epsilon value to account\nfor floating point error. Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in) :: res Real value result being tested. real(kind=wp), intent(in) :: tgt Target real value to compare result to. real(kind=wp) :: eps Allowed margin of error Return Value logical Return whether both values are equal. Contents Source Code realEq Source Code function realEq ( res , tgt , eps ) result ( comp ) !! Test if two real values are equal. Uses an epsilon value to account !! for floating point error. real ( kind = wp ), intent ( in ) :: res !! Real value result being tested. real ( kind = wp ), intent ( in ) :: tgt !! Target real value to compare result to. real ( kind = wp ) :: eps !! Allowed margin of error logical :: comp !! Return whether both values are equal. comp = abs ( res - tgt ) < eps end function realEq","tags":"","loc":"proc/realeq.html"},{"title":"runTestRealArrVal – cafut","text":"public function runTestRealArrVal(self) result(tests_passed) Run test on real arrays and print summary report for images. Arguments Type Intent Optional Attributes Name class( TestRealArrVal ), intent(in) :: self Return Value integer Return the tests that passed up to and including this one in\nthe linked list. Contents Variables i img_passed max_res_n max_tgt_n res res_n tgt tgt_n Source Code runTestRealArrVal Variables Type Visibility Attributes Name Initial integer, public :: i integer, public :: img_passed integer, public :: max_res_n integer, public :: max_tgt_n real(kind=wp), public, allocatable, dimension(:), codimension[:] :: res integer, public, allocatable, codimension[:] :: res_n real(kind=wp), public, allocatable, dimension(:), codimension[:] :: tgt integer, public, allocatable, codimension[:] :: tgt_n Source Code function runTestRealArrVal ( self ) result ( tests_passed ) !! Run test on real arrays and print summary report for images. class ( TestRealArrVal ), intent ( in ) :: self integer :: tests_passed !! Return the tests that passed up to and including this one in !! the linked list. real ( kind = wp ), allocatable , dimension (:), codimension [:] :: res , tgt integer , allocatable , codimension [:] :: res_n , tgt_n integer :: max_res_n , max_tgt_n integer :: img_passed , i if ( associated ( self % next )) then tests_passed = self % next % run () else tests_passed = 0 end if allocate ( res_n [ * ], tgt_n [ * ]) res_n = size ( self % res ) tgt_n = size ( self % tgt ) max_res_n = res_n call co_max ( max_res_n ) max_tgt_n = tgt_n call co_max ( max_tgt_n ) allocate ( res ( max_res_n )[ * ], tgt ( max_tgt_n )[ * ]) res (: res_n ) = self % res tgt (: res_n ) = self % tgt sync all img_passed = 0 if ( this_image () == 1 ) then print SUBTEST_START , self % test_name do i = 1 , num_images () if ( self % compare ( res (: res_n [ i ])[ i ], tgt (: tgt_n [ i ])[ i ], self % eps )) then img_passed = img_passed + 1 else call self % printFail ( i , res (: res_n [ i ])[ i ], tgt (: tgt_n [ i ])[ i ]) end if end do print SUBTEST_END , img_passed , num_images () end if if ( img_passed == num_images ()) tests_passed = tests_passed + 1 deallocate ( res_n , tgt_n , res , tgt ) end function runTestRealArrVal","tags":"","loc":"proc/runtestrealarrval.html"},{"title":"runTestRealVal – cafut","text":"public function runTestRealVal(self) result(tests_passed) Run test on real values and print summary report for images. Arguments Type Intent Optional Attributes Name class( TestRealVal ), intent(in) :: self Return Value integer Return the tests that passed up to and including this one in\nthe linked list. Contents Variables i img_passed res tgt Source Code runTestRealVal Variables Type Visibility Attributes Name Initial integer, public :: i integer, public :: img_passed real(kind=wp), public, allocatable, codimension[:] :: res real(kind=wp), public, allocatable, codimension[:] :: tgt Source Code function runTestRealVal ( self ) result ( tests_passed ) !! Run test on real values and print summary report for images. class ( TestRealVal ), intent ( in ) :: self integer :: tests_passed !! Return the tests that passed up to and including this one in !! the linked list. real ( kind = wp ), allocatable , codimension [:] :: res , tgt integer :: img_passed , i if ( associated ( self % next )) then tests_passed = self % next % run () else tests_passed = 0 end if allocate ( res [ * ], tgt [ * ]) res = self % res tgt = self % tgt sync all img_passed = 0 if ( this_image () == 1 ) then print SUBTEST_START , self % test_name do i = 1 , num_images () if ( self % compare ( res [ i ], tgt [ i ], self % eps )) then img_passed = img_passed + 1 else call self % printFail ( i , res [ i ], tgt [ i ]) end if end do print SUBTEST_END , img_passed , num_images () end if if ( img_passed == num_images ()) tests_passed = tests_passed + 1 end function runTestRealVal","tags":"","loc":"proc/runtestrealval.html"},{"title":"addTestRealArrVal – cafut","text":"public subroutine addTestRealArrVal(self, ut, res, tgt) Compact alternative to add a TestRealArrVal object to the test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self type( TestRealArrVal ), intent(in) :: ut An initialized TestRealArrVal object with the desired name. real(kind=wp), allocatable, dimension(:) :: res See TestRealArrVal. real(kind=wp), allocatable, dimension(:) :: tgt See TestRealArrVal. Contents Variables next Source Code addTestRealArrVal Variables Type Visibility Attributes Name Initial class( Test ), public, pointer :: next Source Code subroutine addTestRealArrVal ( self , ut , res , tgt ) !! Compact alternative to add a TestRealArrVal object to the test suite. class ( TestSuite ), intent ( inout ) :: self type ( TestRealArrVal ), intent ( in ) :: ut !! An initialized TestRealArrVal object with the desired name. real ( kind = wp ), allocatable , dimension (:) :: res , tgt !! See TestRealArrVal. class ( Test ), pointer :: next if ( this_image () == 1 ) self % n_tests = self % n_tests + 1 if ( associated ( self % test )) allocate ( next , source = self % test ) next => self % test allocate ( self % test , source = ut ) associate ( t => self % test ) select type ( t ) type is ( TestRealArrVal ) t % next => next t % test_name = ut % test_name t % res = res t % tgt = tgt end select end associate end subroutine addTestRealArrVal","tags":"","loc":"proc/addtestrealarrval.html"},{"title":"addTestRealVal – cafut","text":"public subroutine addTestRealVal(self, ut, res, tgt) Compact alternative to add a TestRealVal object to the test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self type( TestRealVal ), intent(in) :: ut An initialized TestRealVal object with the desired name. real(kind=wp), intent(in) :: res See TestRealVal. real(kind=wp), intent(in) :: tgt See TestRealVal. Contents Variables next Source Code addTestRealVal Variables Type Visibility Attributes Name Initial class( Test ), public, pointer :: next Source Code subroutine addTestRealVal ( self , ut , res , tgt ) !! Compact alternative to add a TestRealVal object to the test suite. class ( TestSuite ), intent ( inout ) :: self type ( TestRealVal ), intent ( in ) :: ut !! An initialized TestRealVal object with the desired name. real ( kind = wp ), intent ( in ) :: res , tgt !! See TestRealVal. class ( Test ), pointer :: next if ( this_image () == 1 ) self % n_tests = self % n_tests + 1 if ( associated ( self % test )) allocate ( next , source = self % test ) next => self % test allocate ( self % test , source = ut ) associate ( t => self % test ) select type ( t ) type is ( TestRealVal ) t % next => next t % test_name = ut % test_name t % res = res t % tgt = tgt end select end associate end subroutine addTestRealVal","tags":"","loc":"proc/addtestrealval.html"},{"title":"addUnitTest – cafut","text":"public subroutine addUnitTest(self, ut) Add a Test object to the test suite and make it available for setup. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self class( Test ), intent(inout), target :: ut Object derived from the Test abstract type. Contents Variables next Source Code addUnitTest Variables Type Visibility Attributes Name Initial class( Test ), public, pointer :: next Source Code subroutine addUnitTest ( self , ut ) !! Add a Test object to the test suite and make it available for setup. class ( TestSuite ), intent ( inout ) :: self class ( Test ), target , intent ( inout ) :: ut !! Object derived from the Test abstract type. class ( Test ), pointer :: next if ( this_image () == 1 ) self % n_tests = self % n_tests + 1 if ( associated ( self % test )) allocate ( next , source = self % test ) next => self % test ut % next => next self % test => ut end subroutine addUnitTest","tags":"","loc":"proc/addunittest.html"},{"title":"deleteTestRealArrVal – cafut","text":"public subroutine deleteTestRealArrVal(self) Destruct TestRealVal object by deallocating its next object pointer\nas well as its res and tgt arrays. Arguments Type Intent Optional Attributes Name type( TestRealArrVal ), intent(inout) :: self Contents Source Code deleteTestRealArrVal Source Code subroutine deleteTestRealArrVal ( self ) !! Destruct TestRealVal object by deallocating its next object pointer !! as well as its res and tgt arrays. type ( TestRealArrVal ), intent ( inout ) :: self deallocate ( self % next ) deallocate ( self % res ) deallocate ( self % tgt ) end subroutine deleteTestRealArrVal","tags":"","loc":"proc/deletetestrealarrval.html"},{"title":"deleteTestRealVal – cafut","text":"public subroutine deleteTestRealVal(self) Destruct TestRealVal object by deallocating its next object pointer. Arguments Type Intent Optional Attributes Name type( TestRealVal ), intent(inout) :: self Contents Source Code deleteTestRealVal Source Code subroutine deleteTestRealVal ( self ) !! Destruct TestRealVal object by deallocating its next object pointer. type ( TestRealVal ), intent ( inout ) :: self deallocate ( self % next ) end subroutine deleteTestRealVal","tags":"","loc":"proc/deletetestrealval.html"},{"title":"deleteTestSuite – cafut","text":"public subroutine deleteTestSuite(self) Destruct a test suite by deallocating its test pointer attribute. Arguments Type Intent Optional Attributes Name type( TestSuite ), intent(inout) :: self Contents Source Code deleteTestSuite Source Code subroutine deleteTestSuite ( self ) !! Destruct a test suite by deallocating its test pointer attribute. type ( TestSuite ), intent ( inout ) :: self deallocate ( self % test ) end subroutine deleteTestSuite","tags":"","loc":"proc/deletetestsuite.html"},{"title":"printFailTestRealArrVal – cafut","text":"public subroutine printFailTestRealArrVal(img, res, tgt) Print failure message of a real array comparrison. Arguments Type Intent Optional Attributes Name integer, intent(in) :: img Image where the failure occured. real(kind=wp), intent(in), dimension(:) :: res (Incorrect) result array of some procedure. real(kind=wp), intent(in), dimension(:) :: tgt (Correct) target result array of some procedure. Contents Source Code printFailTestRealArrVal Source Code subroutine printFailTestRealArrVal ( img , res , tgt ) !! Print failure message of a real array comparrison. integer , intent ( in ) :: img !! Image where the failure occured. real ( kind = wp ), dimension (:), intent ( in ) :: res !! (Incorrect) result array of some procedure. real ( kind = wp ), dimension (:), intent ( in ) :: tgt !! (Correct) target result array of some procedure. print ARR_VAL_IMG , img print '(A)' , ARR_VAL_RES print * , res print '(A)' , ARR_VAL_EXP print * , tgt end subroutine printFailTestRealArrVal","tags":"","loc":"proc/printfailtestrealarrval.html"},{"title":"printFailTestRealVal – cafut","text":"public subroutine printFailTestRealVal(img, res, tgt) Print failure message of a real value comparrison. Arguments Type Intent Optional Attributes Name integer, intent(in) :: img Image where the failure occured. real(kind=wp), intent(in) :: res (Incorrect) result value of some procedure. real(kind=wp), intent(in) :: tgt (Correct) target result value of some procedure. Contents Source Code printFailTestRealVal Source Code subroutine printFailTestRealVal ( img , res , tgt ) !! Print failure message of a real value comparrison. integer , intent ( in ) :: img !! Image where the failure occured. real ( kind = wp ), intent ( in ) :: res !! (Incorrect) result value of some procedure. real ( kind = wp ), intent ( in ) :: tgt !! (Correct) target result value of some procedure. print SINGLE_VAL_FMT , img , res , tgt end subroutine printFailTestRealVal","tags":"","loc":"proc/printfailtestrealval.html"},{"title":"runTests – cafut","text":"public subroutine runTests(self) Run all tests contained in a test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(in) :: self Contents Variables tot_passed Source Code runTests Variables Type Visibility Attributes Name Initial integer, public :: tot_passed Source Code subroutine runTests ( self ) !! Run all tests contained in a test suite. class ( TestSuite ), intent ( in ) :: self integer :: tot_passed if ( this_image () == 1 ) then print TEST_START , trim ( self % test_suite_name ) end if tot_passed = 0 if ( associated ( self % test )) tot_passed = self % test % run () if ( this_image () == 1 ) then print TEST_END , trim ( self % test_suite_name ), tot_passed , self % n_tests end if end subroutine runTests","tags":"","loc":"proc/runtests.html"},{"title":"TestRealArrVal – cafut","text":"public interface TestRealArrVal Constructor interface for a TestRealArrVal object. Contents Module Procedures newTestRealArrVal_name Module Procedures public function newTestRealArrVal_name (ts_name, eps) result(new_ts) Construct new TestRealArrVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealArrVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealArrVal ) Return new TestRealArrVal object.","tags":"","loc":"interface/testrealarrval.html"},{"title":"TestRealVal – cafut","text":"public interface TestRealVal Constructor interface for a TestRealVal object. Contents Module Procedures newTestRealVal_name Module Procedures public function newTestRealVal_name (ts_name, eps) result(new_ts) Construct new TestRealVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealVal ) Return new TestRealVal object.","tags":"","loc":"interface/testrealval.html"},{"title":"TestSuite – cafut","text":"public interface TestSuite Constructor interface for a TestSuite object. Contents Module Procedures newTestSuite Module Procedures public function newTestSuite (ts_name) result(new_ts) Construct a new test suite. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the test suite. Return Value type( TestSuite ) Return the new test suite.","tags":"","loc":"interface/testsuite.html"},{"title":"realArrCompInterface – cafut","text":"interface public function realArrCompInterface(res, tgt, eps) result(comp) Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in), dimension(:) :: res See res and tgt in TestRealArrVal class. real(kind=wp), intent(in), dimension(:) :: tgt See res and tgt in TestRealArrVal class. real(kind=wp) :: eps Allowed margin of error Return Value logical Return whether or not the test succeeded based on a comparrison. Description Abstract function interface for an array comparisson function.","tags":"","loc":"interface/realarrcompinterface.html"},{"title":"realCompInterface – cafut","text":"interface public function realCompInterface(res, tgt, eps) result(comp) Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in) :: res Result being tested. real(kind=wp), intent(in) :: tgt Target value used to compare result to. real(kind=wp) :: eps Allowed margin of error Return Value logical Return whether or not the test succeeded based on a comparrison. Description Abstract function interface for a value comparisson function.","tags":"","loc":"interface/realcompinterface.html"},{"title":"cafut – cafut","text":"Uses iso_fortran_env Contents Interfaces TestRealArrVal TestRealVal TestSuite realArrCompInterface realCompInterface Abstract Interfaces runInterface Derived Types Test TestRealArrVal TestRealVal TestSuite Functions newTestRealArrVal_name newTestRealVal_name newTestSuite realArrEq realEq runTestRealArrVal runTestRealVal Subroutines addTestRealArrVal addTestRealVal addUnitTest deleteTestRealArrVal deleteTestRealVal deleteTestSuite printFailTestRealArrVal printFailTestRealVal runTests Interfaces public interface TestRealArrVal Constructor interface for a TestRealArrVal object. public function newTestRealArrVal_name (ts_name, eps) result(new_ts) Construct new TestRealArrVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealArrVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealArrVal ) Return new TestRealArrVal object. public interface TestRealVal Constructor interface for a TestRealVal object. public function newTestRealVal_name (ts_name, eps) result(new_ts) Construct new TestRealVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealVal ) Return new TestRealVal object. public interface TestSuite Constructor interface for a TestSuite object. public function newTestSuite (ts_name) result(new_ts) Construct a new test suite. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the test suite. Return Value type( TestSuite ) Return the new test suite. interface public function realArrCompInterface(res, tgt, eps) result(comp) Abstract function interface for an array comparisson function. Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in), dimension(:) :: res See res and tgt in TestRealArrVal class. real(kind=wp), intent(in), dimension(:) :: tgt See res and tgt in TestRealArrVal class. real(kind=wp) :: eps Allowed margin of error Return Value logical Return whether or not the test succeeded based on a comparrison. interface public function realCompInterface(res, tgt, eps) result(comp) Abstract function interface for a value comparisson function. Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in) :: res Result being tested. real(kind=wp), intent(in) :: tgt Target value used to compare result to. real(kind=wp) :: eps Allowed margin of error Return Value logical Return whether or not the test succeeded based on a comparrison. Abstract Interfaces abstract interface public function runInterface(self) result(tests_passed) Abstract function interface for running a test. Arguments Type Intent Optional Attributes Name class( Test ), intent(in) :: self The test itself. The Test object should contain all information\nneeded to run the test. Return Value integer Return total number of tests which passed in the linked list\nup to and including this test. Derived Types type, public, abstract :: Test Abstract class for a single test case. A node in the test linked list. Components Type Visibility Attributes Name Initial character(len=NAME_LENGTH), public :: test_name Name of the test case. Type-Bound Procedures procedure(runInterface), public, pass :: run type, public, extends( Test ) :: TestRealArrVal Test performed on an array of real values. Components Type Visibility Attributes Name Initial procedure( realArrCompInterface ), public, nopass, pointer :: compare Pointer to a comparisson function used to perform the test. real(kind=wp), public, allocatable, dimension(:) :: res Real array result from some process. character(len=NAME_LENGTH), public :: test_name Name of the test case. real(kind=wp), public, allocatable, dimension(:) :: tgt Target real array result for some process. Constructor Constructor interface for a TestRealArrVal object. public  function newTestRealArrVal_name (ts_name, eps) Construct new TestRealArrVal given a name. Finalizations Procedures final :: deleteTestRealArrVal Type-Bound Procedures procedure, public, pass :: run => runTestRealArrVal type, public, extends( Test ) :: TestRealVal Test performed on single real values. Components Type Visibility Attributes Name Initial procedure( realCompInterface ), public, nopass, pointer :: compare Pointer to a comparisson function used to perform the test. real(kind=wp), public :: res Real value result from some process. character(len=NAME_LENGTH), public :: test_name Name of the test case. real(kind=wp), public :: tgt Target real value result for some process. Constructor Constructor interface for a TestRealVal object. public  function newTestRealVal_name (ts_name, eps) Construct new TestRealVal given a name. Finalizations Procedures final :: deleteTestRealVal Type-Bound Procedures procedure, public, pass :: run => runTestRealVal type, public :: TestSuite Holds tests and manages their executtion.\nRepresents a set of procedures to test a certain feature.\nFirst node of the test linked list. Components Type Visibility Attributes Name Initial class( Test ), public, pointer :: test Current test whose attributes are available to be set. Constructor Constructor interface for a TestSuite object. public  function newTestSuite (ts_name) Construct a new test suite. Finalizations Procedures final :: deleteTestSuite Type-Bound Procedures generic, public :: add => addUnitTest, addTestRealVal, addTestRealArrVal procedure, public, pass :: addUnitTest procedure, public, pass :: runTests Functions public function newTestRealArrVal_name (ts_name, eps) result(new_ts) Construct new TestRealArrVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealArrVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealArrVal ) Return new TestRealArrVal object. public function newTestRealVal_name (ts_name, eps) result(new_ts) Construct new TestRealVal given a name. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the new TestRealVal object. real(kind=wp), optional :: eps Allowed margin of error Return Value type( TestRealVal ) Return new TestRealVal object. public function newTestSuite (ts_name) result(new_ts) Construct a new test suite. Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: ts_name Name of the test suite. Return Value type( TestSuite ) Return the new test suite. public function realArrEq (res, tgt, eps) result(comp) Test if two real arrays are exactly equal. Arrays must be of the\nsame length and have the same values in the same positions. Uses\nepsilon value to account for floating point error. Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in), dimension(:) :: res Real value result being tested. real(kind=wp), intent(in), dimension(:) :: tgt Target real value to compare result to. real(kind=wp) :: eps Allowed margin of error Return Value logical public function realEq (res, tgt, eps) result(comp) Test if two real values are equal. Uses an epsilon value to account\nfor floating point error. Arguments Type Intent Optional Attributes Name real(kind=wp), intent(in) :: res Real value result being tested. real(kind=wp), intent(in) :: tgt Target real value to compare result to. real(kind=wp) :: eps Allowed margin of error Return Value logical Return whether both values are equal. public function runTestRealArrVal (self) result(tests_passed) Run test on real arrays and print summary report for images. Arguments Type Intent Optional Attributes Name class( TestRealArrVal ), intent(in) :: self Return Value integer Return the tests that passed up to and including this one in\nthe linked list. public function runTestRealVal (self) result(tests_passed) Run test on real values and print summary report for images. Arguments Type Intent Optional Attributes Name class( TestRealVal ), intent(in) :: self Return Value integer Return the tests that passed up to and including this one in\nthe linked list. Subroutines public subroutine addTestRealArrVal (self, ut, res, tgt) Compact alternative to add a TestRealArrVal object to the test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self type( TestRealArrVal ), intent(in) :: ut An initialized TestRealArrVal object with the desired name. real(kind=wp), allocatable, dimension(:) :: res See TestRealArrVal. real(kind=wp), allocatable, dimension(:) :: tgt See TestRealArrVal. public subroutine addTestRealVal (self, ut, res, tgt) Compact alternative to add a TestRealVal object to the test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self type( TestRealVal ), intent(in) :: ut An initialized TestRealVal object with the desired name. real(kind=wp), intent(in) :: res See TestRealVal. real(kind=wp), intent(in) :: tgt See TestRealVal. public subroutine addUnitTest (self, ut) Add a Test object to the test suite and make it available for setup. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(inout) :: self class( Test ), intent(inout), target :: ut Object derived from the Test abstract type. public subroutine deleteTestRealArrVal (self) Destruct TestRealVal object by deallocating its next object pointer\nas well as its res and tgt arrays. Arguments Type Intent Optional Attributes Name type( TestRealArrVal ), intent(inout) :: self public subroutine deleteTestRealVal (self) Destruct TestRealVal object by deallocating its next object pointer. Arguments Type Intent Optional Attributes Name type( TestRealVal ), intent(inout) :: self public subroutine deleteTestSuite (self) Destruct a test suite by deallocating its test pointer attribute. Arguments Type Intent Optional Attributes Name type( TestSuite ), intent(inout) :: self public subroutine printFailTestRealArrVal (img, res, tgt) Print failure message of a real array comparrison. Arguments Type Intent Optional Attributes Name integer, intent(in) :: img Image where the failure occured. real(kind=wp), intent(in), dimension(:) :: res (Incorrect) result array of some procedure. real(kind=wp), intent(in), dimension(:) :: tgt (Correct) target result array of some procedure. public subroutine printFailTestRealVal (img, res, tgt) Print failure message of a real value comparrison. Arguments Type Intent Optional Attributes Name integer, intent(in) :: img Image where the failure occured. real(kind=wp), intent(in) :: res (Incorrect) result value of some procedure. real(kind=wp), intent(in) :: tgt (Correct) target result value of some procedure. public subroutine runTests (self) Run all tests contained in a test suite. Arguments Type Intent Optional Attributes Name class( TestSuite ), intent(in) :: self","tags":"","loc":"module/cafut.html"}]}