# arch.mk for BerkeleyGW codes
#
# Suitable for generic single-processor MacOS 
# Tested on Intel Macbook with Snow Leopard, Leopard, Lion, Mountain Lion
# Use macports to install g95, fftw, atlas
# Add location of the binaries (/opt/local/bin by default) to PATH
#
# On Leopard atlas that is built by macports is buggy. Install
# atlas on your own and then add all the generic lapack symbols to
# it if needed (as described on their website). The linking is done
# by the commented LAPACKLIB
#
# All tests passed 2 Aug 2012, r4658
#
# D. Strubbe
# Sept 2013, MIT

COMPFLAG  = -DG95
MATHFLAG  = 
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG

FCPP    = clang -P -E -C
F90free = g95 -ffree-form -ffree-line-length-huge -fno-second-underscore
LINK    = g95
FOPTS   = -O3
FNOOPTS = $(FOPTS)
MOD_OPT = -fmod=
INCFLAG = -I

CC_COMP = clang++
C_COMP  = clang
C_LINK  = clang++
C_OPTS  = -O3
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/opt/local/lib/ -ldfftw
FFTWINCLUDE  = /opt/local/include
LAPACKLIB    = -L/opt/local/lib/ -lsatlas
#LAPACKLIB    = /Users/mjain/blas/ATLAS/macosX/lib/liblapack.a /Users/mjain/blas/ATLAS/macosX/lib/libf77blas.a /Users/mjain/blas/ATLAS/macosX/lib/libatlas.a /Users/mjain/blas/ATLAS/macosX/lib/libcblas.a -lpthread -lm

#To build with HDF5, request MacPorts to provide "hdf5-18 +fortran +g95" ...
