# arch.mk for BerkeleyGW codes
#
# g95 serial
# needs packages liblapack-dev, fftw-dev, g++ packages 
#
# D. Strubbe
# September 2010, UCB

COMPFLAG  = -DG95
MATHFLAG  = 
# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG

# note that we use many cpp features that g95 -cpp does not support, so you cannot use g95's built-in cpp
FCPP    = cpp -P -C
F90free = g95 -ffree-form -ffree-line-length-huge -fno-second-underscore
#F90free = g95 -fbounds-check -ftrace=full -ffree-form -ffree-line-length-huge -fno-second-underscore
# debug flags: -ftrace=full will identify memory leaks
LINK    = g95
FOPTS   = -O3
FNOOPTS = $(FOPTS)
MOD_OPT = -fmod=
INCFLAG = -I

CC_COMP = g++
C_COMP  = gcc
C_LINK  = g++
C_OPTS  = -O3
C_DEBUGFLAG =
# You might have to change the search directory below
CC_LINK_LIBS = -L/usr/lib/gcc/x86_64-linux-gnu/4.4 -lstdc++

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/usr/lib/ -lfftw
FFTWINCLUDE  = /usr/share/doc/fftw-dev/fortran
LAPACKLIB    = -L/usr/lib/ -llapack
