# arch.mk for BerkeleyGW codes
#
# Suitable for generic single-processor FreeBSD 11.0
# 
# You'll need to instal the following packages/ports:
# gmake gcc6 blas lapack fftw3 hdf5
#
# Compile with (GNU) gmake, not (BSD) make
#
# All tests passed Jan 2018, r7231
# FHJ

COMPFLAG  = -DGNU
MATHFLAG  = -DUSEFFTW3 -DUNPACKED #-DHDF5
# FHJ: Note: we are not using HDF5 right now because the library
# that comes with the binary package does not include Fortran bindings,

# Only uncomment DEBUGFLAG if you need to develop/debug BerkeleyGW.
# The output will be much more verbose, and the code will slow down by ~20%.
#DEBUGFLAG = -DDEBUG

MAKE    = gmake
FCPP    = cpp6 -C -nostdinc
F90free = gfortran6 -ffree-form -ffree-line-length-none
LINK    = gfortran6 -rpath /usr/local/lib/gcc6
FOPTS   = -O3
FNOOPTS = -O1
MOD_OPT = -J
INCFLAG = -I

CC_COMP = g++6
C_COMP  = gcc6
C_LINK  = g++6 -rpath /usr/local/lib/gcc6
C_OPTS  = -O3
C_DEBUGFLAG =

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/usr/local/lib/ -lfftw3
FFTWINCLUDE  = /usr/local/include
LAPACKLIB    = -L/usr/local/lib/ -llapack -lblas


#HDF5_DIR     =  /usr/local
#HDF5_LDIR    =  $(HDF5_DIR)/lib
#HDF5LIB      =  $(HDF5_LDIR)/libhdf5hl_fortran.a \
#                $(HDF5_LDIR)/libhdf5_hl.a \
#                $(HDF5_LDIR)/libhdf5_fortran.a \
#                $(HDF5_LDIR)/libhdf5.a -lz -ldl
#HDF5INCLUDE  = $(HDF5_DIR)/include
