#!/usr/bin/env python

from mako.template import Template
from mako.exceptions import RichTraceback
import sys
import time
import itertools

def gen_test(fname_in, fname_out):
    template = Template(filename=fname_in)
    try:
        s = template.render(**globals())
    except:
        traceback = RichTraceback()
        for (filename, lineno, function, line) in traceback.traceback:
            print "File %s, line %s, in %s" % (filename, lineno, function)
            print line, "\n"
        print "%s: %s" % (str(traceback.error.__class__.__name__), traceback.error)
        raise

    with open(fname_out, 'w') as f:
        f.write('')
        f.write(s)


if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('fname_in')
    parser.add_argument('fname_out')
    args = parser.parse_args()
    gen_test(args.fname_in, args.fname_out)
