/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.util.HashSet;
import java.util.regex.Matcher;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.query.value.item.QNm;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

public final class IndexNames {
    private final Atts qnames = new Atts();
    private final Data data;

    public IndexNames(IndexType type, Data data) {
        this.data = data;
        String names = data.meta.names(type);
        HashSet<String> inc = IndexNames.toSet(names.trim());
        for (String entry : inc) {
            String ln;
            String uri;
            if (entry.equals("*") || entry.equals("*:*")) {
                this.qnames.reset();
                return;
            }
            Matcher m = QNm.EQNAME.matcher(entry);
            if (m.find()) {
                uri = m.group(1);
                ln = m.group(2).equals("*") ? null : m.group(2);
            } else if (entry.startsWith("*:")) {
                uri = null;
                ln = entry.substring(2);
            } else if (XMLToken.isNCName(Token.token(entry))) {
                uri = "";
                ln = entry;
            } else {
                Util.debugln("Included name is invalid: %", entry);
                continue;
            }
            this.qnames.add(ln == null ? null : Token.token(ln), uri == null ? null : Token.token(uri));
        }
    }

    public boolean isEmpty() {
        return this.qnames.isEmpty();
    }

    public boolean contains(int pre, boolean text) {
        byte[][] qname = text ? this.data.qname(this.data.parent(pre, 2), 1) : this.data.qname(pre, 3);
        qname[0] = Token.local(qname[0]);
        return this.contains(qname);
    }

    public boolean contains(byte[][] qname) {
        if (this.isEmpty()) {
            return true;
        }
        if (qname != null) {
            int ns = this.qnames.size();
            byte[] ln = qname[0];
            byte[] uri = qname[1];
            for (int n = 0; n < ns; ++n) {
                byte[] iuri;
                byte[] iln = this.qnames.name(n);
                if (iln != null && (ln == null || !Token.eq(ln, iln)) || (iuri = this.qnames.value(n)) != null && (uri == null || !Token.eq(uri, iuri))) continue;
                return true;
            }
        }
        return false;
    }

    private static HashSet<String> toSet(String names) {
        HashSet<String> set = new HashSet<String>();
        StringBuilder value = new StringBuilder();
        int sl = names.length();
        for (int s = 0; s < sl; ++s) {
            char ch = names.charAt(s);
            if (ch == ',') {
                if (s + 1 == sl || names.charAt(s + 1) != ',') {
                    if (value.isEmpty()) continue;
                    set.add(value.toString().trim());
                    value.setLength(0);
                    continue;
                }
                ++s;
            }
            value.append(ch);
        }
        if (!value.isEmpty()) {
            set.add(value.toString().trim());
        }
        return set;
    }

    public boolean containsIds(boolean idref) {
        if (this.isEmpty()) {
            return true;
        }
        if (this.data.nspaces.isEmpty()) {
            return false;
        }
        TokenSet names = new TokenSet();
        int ns = this.qnames.size();
        for (int n = 0; n < ns; ++n) {
            byte[] name = this.qnames.name(n);
            if (name == null || !XMLToken.isId(name, idref)) continue;
            names.add(name);
        }
        for (byte[] name : this.data.attrNames) {
            if (!XMLToken.isId(name, idref && !names.contains(name))) continue;
            return false;
        }
        return true;
    }
}

