const en = {
  "/guide/": ["/guide/introduction.md", "/guide/getting-started.md"],
  "/manage/": [
    {
      text: "Manage",
      children: [
        "/manage/core.md",
        "/manage/plugins.md",
        "/manage/versions.md",
        "/manage/configuration.md",
        "/manage/commands.md",
        {
          text: "Changelog",
          link: "https://github.com/asdf-vm/asdf/blob/master/CHANGELOG.md"
        }
      ]
    }
  ],
  "/plugins/": [
    {
      text: "Author",
      children: [
        "/plugins/create.md",
        {
          text: "GitHub Plugin Template",
          link: "https://github.com/asdf-vm/asdf-plugin-template"
        }
      ]
    },
    {
      text: "First Party Plugins",
      children: [
        {
          text: "Elixir",
          link: "https://github.com/asdf-vm/asdf-elixir"
        },
        {
          text: "Erlang",
          link: "https://github.com/asdf-vm/asdf-erlang"
        },
        {
          text: "Node.js",
          link: "https://github.com/asdf-vm/asdf-nodejs"
        },
        {
          text: "Ruby",
          link: "https://github.com/asdf-vm/asdf-ruby"
        }
      ]
    },
    {
      text: "Community Plugins",
      children: [
        {
          text: "asdf-community",
          link: "https://github.com/asdf-community/"
        }
      ]
    },
    {
      text: "Reference",
      children: [
        {
          text: "Plugin Shortname Index",
          link: "https://github.com/asdf-vm/asdf-plugins"
        }
      ]
    }
  ],
  "/contribute/": [
    {
      text: "Contribute",
      children: [
        "/contribute/core.md",
        "/contribute/documentation.md",
        "/contribute/first-party-plugins.md",
        "/contribute/github-actions.md"
      ]
    }
  ],
  "/learn-more/": [
    {
      text: "Questions",
      children: [
        "/learn-more/faq.md",

        {
          text: "GitHub Issues",
          link: "https://github.com/asdf-vm/asdf/issues"
        },
        {
          text: "StackOverflow Tag",
          link: "https://stackoverflow.com/questions/tagged/asdf-vm"
        }
      ]
    },
    {
      text: "Resources",
      children: ["/learn-more/thanks.md"]
    }
  ]
};

const pt_br = {
  "/pt-br/guide/": [
    "/pt-br/guide/introduction.md",
    "/pt-br/guide/getting-started.md"
  ],
  "/pt-br/manage/": [
    {
      text: "Manage",
      children: [
        "/pt-br/manage/core.md",
        "/pt-br/manage/plugins.md",
        "/pt-br/manage/versions.md",
        "/pt-br/manage/configuration.md",
        "/pt-br/manage/commands.md",
        {
          text: "Alterações",
          link: "https://github.com/asdf-vm/asdf/blob/master/CHANGELOG.md"
        }
      ]
    }
  ],
  "/pt-br/plugins/": [
    {
      text: "Author",
      children: [
        "/pt-br/plugins/create.md",
        {
          text: "GitHub Plugin Template",
          link: "https://github.com/asdf-vm/asdf-plugin-template"
        }
      ]
    },
    {
      text: "First Party Plugins",
      children: [
        {
          text: "Elixir",
          link: "https://github.com/asdf-vm/asdf-elixir"
        },
        {
          text: "Erlang",
          link: "https://github.com/asdf-vm/asdf-erlang"
        },
        {
          text: "Node.js",
          link: "https://github.com/asdf-vm/asdf-nodejs"
        },
        {
          text: "Ruby",
          link: "https://github.com/asdf-vm/asdf-ruby"
        }
      ]
    },
    {
      text: "Community Plugins",
      children: [
        {
          text: "asdf-community",
          link: "https://github.com/asdf-community/"
        }
      ]
    },
    {
      text: "Reference",
      children: [
        {
          text: "Plugin Shortname Index",
          link: "https://github.com/asdf-vm/asdf-plugins"
        }
      ]
    }
  ],
  "/pt-br/contribute/": [
    {
      text: "Contribute",
      children: [
        "/pt-br/contribute/core.md",
        "/pt-br/contribute/documentation.md",
        "/pt-br/contribute/first-party-plugins.md",
        "/pt-br/contribute/github-actions.md"
      ]
    }
  ],
  "/pt-br/learn-more/": [
    {
      text: "Questions",
      children: [
        "/pt-br/learn-more/faq.md",

        {
          text: "GitHub Issues",
          link: "https://github.com/asdf-vm/asdf/issues"
        },
        {
          text: "StackOverflow Tag",
          link: "https://stackoverflow.com/questions/tagged/asdf-vm"
        }
      ]
    },
    {
      text: "Resources",
      children: ["/pt-br/learn-more/thanks.md"]
    }
  ]
};

const zh_hans = {
  "/zh-hans/guide/": [
    "/zh-hans/guide/introduction.md",
    "/zh-hans/guide/getting-started.md"
  ],
  "/zh-hans/manage/": [
    {
      text: "管理",
      children: [
        "/zh-hans/manage/core.md",
        "/zh-hans/manage/plugins.md",
        "/zh-hans/manage/versions.md",
        "/zh-hans/manage/configuration.md",
        "/zh-hans/manage/commands.md",
        {
          text: "更新日志",
          link: "https://github.com/asdf-vm/asdf/blob/master/CHANGELOG.md"
        }
      ]
    }
  ],
  "/zh-hans/plugins/": [
    {
      text: "成为作者",
      children: [
        "/zh-hans/plugins/create.md",
        {
          text: "GitHub Plugin 模板",
          link: "https://github.com/asdf-vm/asdf-plugin-template"
        }
      ]
    },
    {
      text: "官方插件",
      children: [
        {
          text: "Elixir",
          link: "https://github.com/asdf-vm/asdf-elixir"
        },
        {
          text: "Erlang",
          link: "https://github.com/asdf-vm/asdf-erlang"
        },
        {
          text: "Node.js",
          link: "https://github.com/asdf-vm/asdf-nodejs"
        },
        {
          text: "Ruby",
          link: "https://github.com/asdf-vm/asdf-ruby"
        }
      ]
    },
    {
      text: "社区插件",
      children: [
        {
          text: "asdf-community",
          link: "https://github.com/asdf-community/"
        },
        {
          text: "GitHub 主题搜索",
          link: "https://github.com/topics/asdf-plugin"
        }
      ]
    },
    {
      text: "参考",
      children: [
        {
          text: "插件缩写索引",
          link: "https://github.com/asdf-vm/asdf-plugins"
        }
      ]
    }
  ],
  "/zh-hans/contribute/": [
    {
      text: "如何贡献",
      children: [
        "/zh-hans/contribute/core.md",
        "/zh-hans/contribute/documentation.md",
        "/zh-hans/contribute/first-party-plugins.md",
        "/zh-hans/contribute/github-actions.md"
      ]
    }
  ],
  "/zh-hans/learn-more/": [
    {
      text: "常见问题",
      children: [
        "/zh-hans/learn-more/faq.md",

        {
          text: "GitHub Issues",
          link: "https://github.com/asdf-vm/asdf/issues"
        },
        {
          text: "StackOverflow Tag",
          link: "https://stackoverflow.com/questions/tagged/asdf-vm"
        }
      ]
    },
    {
      text: "资源",
      children: ["/zh-hans/learn-more/thanks.md"]
    }
  ]
};

module.exports = { en, pt_br, zh_hans };
