/**
 * \file list-parser-errors.h
 * \brief Parse errors and descriptions
 */

PARSE_ERROR(NONE,					"(none)")
PARSE_ERROR(BAD_EXPRESSION_STRING,	"bad expression string")
PARSE_ERROR(ELEMENT_NAME_MISMATCH,	"element name mismatch")
PARSE_ERROR(FIELD_TOO_LONG,			"field too long")
PARSE_ERROR(GENERIC,				"generic error")
PARSE_ERROR(INTERNAL,				"internal error")
PARSE_ERROR(INVALID_ALLOCATION,		"invalid allocation")
PARSE_ERROR(INVALID_COLOR,			"invalid colour")
PARSE_ERROR(INVALID_DICE,			"invalid dice")
PARSE_ERROR(INVALID_EFFECT,			"invalid effect")
PARSE_ERROR(INVALID_EXPRESSION,		"invalid expression")
PARSE_ERROR(INVALID_FLAG,			"invalid flag")
PARSE_ERROR(INVALID_ID_TYPE,		"invalid object property id type")
PARSE_ERROR(INVALID_ITEM_NUMBER,	"invalid item number")
PARSE_ERROR(INVALID_ITERATE,		"invalid power calculation iterate")
PARSE_ERROR(INVALID_LIGHTING,		"invalid lighting")
PARSE_ERROR(INVALID_MESSAGE,		"invalid message")
PARSE_ERROR(INVALID_MONSTER_BASE,	"invalid monster base")
PARSE_ERROR(INVALID_MONSTER,		"invalid monster race")
PARSE_ERROR(INVALID_OBJ_PROP_CODE,	"invalid object property code")
PARSE_ERROR(INVALID_OPTION,			"invalid option")
PARSE_ERROR(INVALID_OPERATION,		"invalid power calculation operation")
PARSE_ERROR(INVALID_PROPERTY,		"invalid object property type")
PARSE_ERROR(INVALID_SLAY,			"invalid slay")
PARSE_ERROR(INVALID_SPELL_FREQ,		"invalid spell frequency")
PARSE_ERROR(INVALID_SPELL_NAME,		"invalid spell name")
PARSE_ERROR(INVALID_SPELL_STAT,		"invalid spell stat")
PARSE_ERROR(INVALID_SUBTYPE,		"invalid object property subtype")
PARSE_ERROR(INVALID_VALUE,			"invaild value")
PARSE_ERROR(MISSING_BLOW_EFF_TYPE,	"missing blow effect type")
PARSE_ERROR(MISSING_FIELD,			"missing field")
PARSE_ERROR(MISSING_OBJ_PROP_TYPE,	"missing object property type")
PARSE_ERROR(MISSING_RECORD_HEADER,	"missing record header")
PARSE_ERROR(NO_ARTIFACT_NAME,		"artifact name not found")
PARSE_ERROR(NO_BUILDER_FOUND,		"no builder found")
PARSE_ERROR(NO_FILE_FOUND,			"no file found")
PARSE_ERROR(NO_KIND_FOR_EGO_TYPE,	"no kind for ego type")
PARSE_ERROR(NO_KIND_FOUND,			"no kind found")
PARSE_ERROR(NO_ROOM_FOUND,			"no room found")
PARSE_ERROR(NON_SEQUENTIAL_RECORDS,	"non-sequential records")
PARSE_ERROR(NOT_NUMBER,				"not a number")
PARSE_ERROR(NOT_RANDOM,				"not random")
PARSE_ERROR(NOT_SPECIAL_ARTIFACT,	"not a special artifact")
PARSE_ERROR(OBSOLETE_FILE,			"obsolete file")
PARSE_ERROR(OUT_OF_BOUNDS,			"out of bounds")
PARSE_ERROR(OUT_OF_MEMORY,			"out of memory")
PARSE_ERROR(TOO_FEW_ENTRIES,		"too few entries")
PARSE_ERROR(TOO_MANY_ENTRIES,		"too many entries")
PARSE_ERROR(UNBOUND_EXPRESSION,		"unbound expression")
PARSE_ERROR(UNDEFINED_DIRECTIVE,	"undefined directive")
PARSE_ERROR(UNRECOGNISED_BLOW,		"unrecognized blow")
PARSE_ERROR(UNRECOGNISED_BRAND,		"unrecognized brand")
PARSE_ERROR(UNRECOGNISED_SLAY,		"unrecognized slay")
PARSE_ERROR(UNRECOGNISED_CURSE,		"unrecognized curse")
PARSE_ERROR(UNRECOGNISED_TRAP,		"unrecognized trap")
PARSE_ERROR(UNRECOGNISED_TVAL,		"unrecognized tval")
PARSE_ERROR(UNRECOGNISED_SVAL,		"unrecognized sval")
PARSE_ERROR(UNRECOGNISED_PARAMETER,	"unrecognized parameter")
PARSE_ERROR(VAULT_TOO_BIG,			"vault too big")
PARSE_ERROR(VAULT_DESC_WRONG_LENGTH,"bad vault description line length")
