\name{dim}
\alias{dim}
\alias{dim.weyl}
\alias{dimension}
\title{The dimension of a \code{weyl} object}
\description{

  The \dfn{dimension} of a weyl algebra is the number of variables
  needed; it is half the \code{spray::arity()}.  The \dfn{dimension} of
  a Weyl algebra generated by \eqn{\left\lbrace
  x_1,x_2,\ldots,x_n,\partial_{x_1},\partial_{x_2},\ldots,\partial_{x_n}\right\rbrace}{omitted}
  is \eqn{n} (not \eqn{2n}).
}
\usage{\method{dim}{weyl}(x)}
\arguments{\item{x}{Object of class \code{weyl}}}
\value{Integer}
\note{Empty spray objects give zero-dimensional weyl objects.}
\author{Robin K. S. Hankin}
\examples{

(a <- rweyl())
dim(a)

}


