% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-andrews.r
\name{display_andrews}
\alias{display_andrews}
\alias{animate_andrews}
\title{Andrews' curves tour path animation.}
\usage{
display_andrews(col = "black", ...)

animate_andrews(data, tour_path = grand_tour(3), col = "black", ...)
}
\arguments{
\item{col}{color to be plotted.  Defaults to "black"}

\item{...}{other arguments passed on to \code{\link{animate}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}
}
\description{
Animate a nD tour path with Andrews' curves.  For more details about
Andrew's curves, see \code{\link{andrews}}
}
\examples{
animate_andrews(flea[, 1:6])
animate_andrews(flea[, 1:6], grand_tour(d = 3))
animate_andrews(flea[, 1:6], grand_tour(d = 6))

# It's easy to experiment with different tour paths:
animate_andrews(flea[, 1:6], guided_tour(cmass()))
}
\seealso{
\code{\link{animate}} for options that apply to all animations
}
\keyword{hplot}
