% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.duration.R
\name{edgecov.mean.age-ergmTerm}
\alias{edgecov.mean.age-ergmTerm}
\alias{InitErgmTerm.edgecov.mean.age}
\title{Weighted average age of an extant tie}
\usage{
# binary: edgecov.mean.age(x, attrname=NULL, emptyval=0)
}
\arguments{
\item{x, attrname}{either a square matrix of covariates, one for
each possible edge in the network, the name of a network
attribute of covariates, or a network; if the latter, or if the
network attribute named by \code{x} is itself a network, optional
argument \code{attrname} provides the name of the quantitative edge
attribute to use for covariate values (in this case, missing
edges in \code{x} are assigned a covariate value of zero).}

\item{emptyval}{can be used to specify the value returned if the network is empty (or all extant edges have been weighted 0). This is, technically, an arbitrary value, but it should
not have a substantial effect unless a non-negligible fraction of
networks at the parameter configuration of interest is empty
and/or if only a few dyads have nonzero weights.}
}
\description{
Weighted average age of an extant tie
}
\details{
This term adds one statistic equaling the average, over all ties
present in the network, of the amount of time elapsed since
formation, weighted by a (nonnegative) dyadic covariate.

The behavior when there are negative weights is undefined.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "edgecov.mean.age", "subsection")}
}
\concept{durational}
