% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{superdiagPlot}
\alias{superdiagPlot}
\alias{superdiagPlot.mcmc}
\alias{superdiagPlot.mcmc.list}
\title{Summary Plots for \code{mcmc} Objects}
\usage{
superdiagPlot(
  mcmcoutput,
  burnin,
  params,
  title,
  col,
  trace.options,
  density.options,
  title.options
)

\method{superdiagPlot}{mcmc}(
  mcmcoutput,
  burnin,
  params = "all",
  title,
  col = c("grey25", "grey75"),
  trace.options = list(trace.axis = TRUE, box = TRUE),
  density.options = list(),
  title.options = list()
)

\method{superdiagPlot}{mcmc.list}(
  mcmcoutput,
  burnin,
  params = "all",
  title,
  col,
  trace.options = list(trace.axis = TRUE, box = TRUE),
  density.options = list(),
  title.options = list()
)
}
\arguments{
\item{mcmcoutput}{A \code{mcmc} or \code{mcmc.list} object.}

\item{burnin}{The number of burn-in iterations. Defaults to half of the chain(s).}

\item{params}{The parameters to be summarized. Defaults to all. Users can specify
a subset of variables by name or index to reduce the size of plots.}

\item{title}{A character vector specifies the title of the plot.}

\item{col}{A vector or list specifies the color schemes of the plot. For \code{mcmc}
object, the default is a two-color grey scheme; Users can specify any numbers of color
no more than the number of variables. For \code{mcmc.list} object, it requires a list
or vector with multiple colors to examine the mixing. The default is a list of two sets
of colors.}

\item{trace.options}{Additional options for trace plots. It can take arguments as
in \code{plot} and \code{lines} functions.}

\item{density.options}{Additional options for density histograms. It can take arguments
as in \code{hist} (e.g \code{breaks}, \code{freq}, \code{probability}) and \code{barplot}
functions.}

\item{title.options}{Additional options for title. It can take arguments as in
\code{mtext} function.}
}
\value{
A summary plot for each variable in the MCMC chain(s).
}
\description{
The \code{superdiagPlot} function takes \code{mcmc} or \code{mcmc.list} as input.
  It provides summary plots including trace plot(s) and density histogram(s) for
  each variable in the MCMC chain(s).
}
\examples{
\dontrun{

data(tobit.list)
summary(tobit.list[1])

# FOR mcmc.list OBJECT
superdiagPlot(tobit.list, burnin=0)

# FOR mcmc OBJECT
superdiagPlot(tobit.list[[1]], burnin=0, col=c("grey25", "dodgerblue"),
  title = "Tobit Model (Chain 1)", title.options=list(cex=1.2))
}

}
\seealso{
\code{\link{superdiag}}
}
