% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartr.R
\name{strtrans}
\alias{strtrans}
\alias{chartr2}
\alias{chartr}
\alias{tolower}
\alias{toupper}
\alias{casefold}
\title{Transliteration and Other Text Transforms}
\usage{
strtrans(x, transform)

chartr2(x, pattern, replacement)

chartr(old, new, x)

tolower(x, locale = NULL)

toupper(x, locale = NULL)

casefold(x, upper = NA)
}
\arguments{
\item{x}{character vector (or an object coercible to)}

\item{transform}{single string with ICU general transform
specifier, see \code{\link[stringi]{stri_trans_list}}}

\item{pattern, old}{single string}

\item{replacement, new}{single string,
preferably of the same length as \code{old}}

\item{locale}{\code{NULL} or \code{""} for the default locale
(see \code{\link[stringi]{stri_locale_get}})
or a single string with a locale identifier,
see \code{\link[stringi]{stri_locale_list}}}

\item{upper}{single logical value; switches between case folding
(the default, \code{NA}), lower-, and upper-case}
}
\value{
These functions return a character vector (in UTF-8).
They preserve most attributes of \code{x}.
Note that their base R counterparts drop all the attributes
if not fed with character vectors.
}
\description{
These functions can be used to translate characters, including case mapping
and folding, script to script conversion, and Unicode normalisation.
}
\details{
\code{tolower} and \code{toupper} perform case mapping.
\code{chartr2} (and [DEPRECATED] \code{chartr}) translate individual code points.
\code{casefold} commits case folding.
The new function \code{strtrans} applies general \pkg{ICU} transforms,
see \code{\link[stringi]{stri_trans_general}}.
}
\section{Differences from Base R}{

Unlike their base R counterparts, the new \code{tolower} and
\code{toupper} are locale-sensitive;
see \code{\link[stringi]{stri_trans_tolower}}.

The base \code{\link[base]{casefold}} simply dispatches to
\code{tolower} or \code{toupper}
'for compatibility with S-PLUS' (which was only crucial long time ago).
The version implemented here, by default, performs the true case folding,
whose purpose is to make two pieces of text that differ only in case
identical, see \code{\link[stringi]{stri_trans_casefold}}.

\code{chartr2} and [DEPRECATED] \code{chartr} are
wrappers for \code{\link[stringi]{stri_trans_char}}.
Contrary to the base \code{\link[base]{chartr}}, they always generate
a warning when \code{old} and \code{new} are of different lengths.
\code{chartr2} has argument order and naming consistent with
\code{\link{gsub}}.
}

\examples{
strtrans(strcat(letters_bf), "Any-NFKD; Any-Upper")
strtrans(strcat(letters_bb[1:6]), "Any-Hex/C")
strtrans(strcat(letters_greek), "Greek-Latin")

toupper(letters_greek)
tolower(LETTERS_GREEK)

base::toupper("gro\u00DF")
stringx::toupper("gro\u00DF")

casefold("gro\u00DF")

x <- as.matrix(c(a="\u00DFpam ba\U0001D554on spam", b=NA))
chartr("\u00DF\U0001D554aba", "SCXBA", x)

toupper('i', locale='en_US')
toupper('i', locale='tr_TR')

}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}
}
