% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with_vg.R
\name{ph_with.dml}
\alias{ph_with.dml}
\title{add a plot output as vector graphics into a PowerPoint object}
\usage{
\method{ph_with}{dml}(x, value, location, ...)
}
\arguments{
\item{x}{a pptx device}

\item{value}{\code{\link{dml}} object}

\item{location}{a location for a placeholder.}

\item{...}{Arguments to be passed to methods}
}
\description{
produces a vector graphics output from R plot instructions
stored in a \code{\link{dml}} object and add the result in an \code{rpptx}
object produced by \code{\link[officer]{read_pptx}}.
}
\examples{
anyplot <- dml(code = barplot(1:5, col = 2:6), bg = "wheat")

library(officer)
doc <- read_pptx()
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with(doc, anyplot, location = ph_location_fullsize())

fileout <- tempfile(fileext = ".pptx")
print(doc, target = fileout)
}
