% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune.rrmix}
\alias{tune.rrmix}
\title{Reduced-rank mixture models with optimal tuning parameter(s)}
\usage{
tune.rrmix(K = NULL, K.max = NULL, X, Y, est = c("FR", "RP", "ANNP"),
           lambda = NULL, n.lambda = 20, gamma = 2,
           ind0 = NULL, para0 = NULL, seed = NULL, kmscale = FALSE, km.nstart = 20,
           n.init = 100, commonvar = FALSE, maxiter = 1000, maxiter.int = 100,
           thres = 1e-05, thres.int = 1e-05, 
           para.true = NULL, ind.true = NULL)
}
\arguments{
\item{K}{number of mixture components. Required when K.max is `NULL'.}

\item{K.max}{maximum of mixture components. Default is `NULL'. When provided,
the argument K is ignored.}

\item{X}{n by p design matrix where n is the number of observations and
p is the number of predictors.}

\item{Y}{n by q response matrix where n is the number of observations and
q is the number of responses.}

\item{est}{character, specifying the estimation method. `FR', `RP', and `ANNP'
refers to as the full-ranked, rank-penalized, and adaptive nuclear norm
penalized method, respectively.}

\item{lambda}{vector consisting of lambda candidates. Only used in the
estimation method of `RP' and `ANNP'. If 0, all estimation methods (`FR',
`RP', and `ANNP') provide the same estimation results. Default is 'NULL'.
If 'NULL', data-adaptive range of lambda will be provided internally.}

\item{n.lambda}{number of lambda candidates to explore. Only used when
'lambda' is 'NULL'. Default is 20.}

\item{gamma}{numerical value, specifying additional tuning parameter, only
used in the estimation method of `ANNP'. It must be nonnegative.}

\item{ind0}{vector of length n, specifying the initial assignment of the
mixture membership of n observations when there is prior information on
the membership. If `NULL', K-means clustering technique is used to assign
the membership for n observations. Default is `NULL'.}

\item{para0}{array of length K. It consists of K lists, each of which contains
initial values of membership probability, coefficient matrix, and variance-
covariance matrix.}

\item{seed}{seed number for the reproducibility of results. Default of `NULL'.}

\item{kmscale}{logical value, indicating whether Y is scaled prior to K-means
clustering for initialization. Default is `FALSE'.}

\item{km.nstart}{number of random sets considered to perform K-means
clustering for initialization. Default is 20.}

\item{n.init}{number of initializations to try. Two methods for initial
clustering are used: K-means and random clustering.}

\item{commonvar}{logical value, indicating the homogeneity assumption of
variance-covariance matrices across K mixture components. Default is `FALSE'.}

\item{maxiter}{maximum number of iterations for external iterative
algorithm, used in all estimation methods.}

\item{maxiter.int}{maximum number of iterations for internal iterative
algorithm, only used in the estimation method of `ANNP'.}

\item{thres}{threshold value for external EM algorithm, used in all
estimation methods. It controls the termination of the EM algorithm.}

\item{thres.int}{threshold value for internal iterative algorithm, only used
 in the estimation method of `ANNP'. It controls the termination of the
internal algorithm.}

\item{para.true}{array of length K. It consists of K lists, each of which
contains a coefficient matrix and its true rank. Only used when true models
are known, e.g., in a simulation study.}

\item{ind.true}{vector of length n, specifying the true mixture membership
for n observations. Only used when true models are known, e.g., in a
simulation study.}
}
\value{
\item{lambda.cand}{lambda values used as input.}
  \item{penloglik}{penalized log-likelihood values corresponding to the set
    of lambda values.}
  \item{bic}{BIC values corresponding to the set of lambda values.}
  \item{est.rank}{estimated ranks corresponding to the set of lambda values.}
}
\description{
Reduced-rank mixture models with optimal tuning parameter(s)
}
\examples{
#-----------------------------------------------------------#
# Real Data Example: Tuna Data
#-----------------------------------------------------------#
require(bayesm)
data(tuna)
tunaY <- log(tuna[, c("MOVE1", "MOVE2", "MOVE3", "MOVE4",
                  "MOVE5", "MOVE6", "MOVE7")])
tunaX <- tuna[, c("NSALE1", "NSALE2", "NSALE3", "NSALE4",
              "NSALE5", "NSALE6", "NSALE7",
              "LPRICE1", "LPRICE2", "LPRICE3", "LPRICE4",
              "LPRICE5", "LPRICE6", "LPRICE7")]
tunaX <- cbind(intercept = 1, tunaX)

\donttest{
tuna.tune <- tune.rrmix(K.max = 3, X = tunaX, Y = tunaY, est = "RP",
             lambda = exp(seq(0, log(100), length = 20)),
             seed = 100, n.init = 100)
summary(tuna.tune)
plot(tuna.tune, transform.y = log, ylab = "log(lambda)")} 
}
\references{
Kang, S., Chen, K., and Yao, W. (2022+). "Reduced rank estimation in mixtures
  of multivariate linear regression".
}
\seealso{
\code{\link{rrmix}}
}
\author{
Suyeon Kang, University of California, Riverside, \email{skang062@ucr.edu};
  Weixin Yao, University of California, Riverside, \email{weixin.yao@ucr.edu};
  Kun Chen, University of Connecticut, \email{kun.chen@uconn.edu}.
}
