% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{predict.rq.pen.seq.cv}
\alias{predict.rq.pen.seq.cv}
\title{Predictions from rq.pen.seq.cv object}
\usage{
\method{predict}{rq.pen.seq.cv}(
  object,
  newx,
  tau = NULL,
  septau = TRUE,
  cvmin = TRUE,
  useDefaults = TRUE,
  ...
)
}
\arguments{
\item{object}{rq.pen.seq.cv object}

\item{newx}{Matrix of predictors}

\item{tau}{Quantile of interest. Default is NULL, which will return all quantiles. Should not be specified if modelsIndex is used.}

\item{septau}{Whether tuning parameter should be optimized separately for each quantile.}

\item{cvmin}{If TRUE then minimum error is used, if FALSE then one standard error rule is used.}

\item{useDefaults}{Whether the default results are used. Set to FALSE if you you want to specify specific models and lambda values.}

\item{...}{Additional parameters sent to coef.rq.pen.seq.cv().}
}
\value{
A matrix of predictions for each tau and a combination
}
\description{
Predictions from rq.pen.seq.cv object
}
\examples{
x <- matrix(runif(1600),ncol=8)
y <- 1 + x[,1] + x[,8] + (1+.5*x[,3])*rnorm(200)
m1 <- rq.pen.cv(x,y,penalty="ENet",a=c(0,.5,1),tau=c(.25,.75),lambda=c(.1,.05,.01))
newx <- matrix(runif(80),ncol=8)
cvpreds <- predict(m1,newx)
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu}
}
