% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistence-diagram.R
\name{plot.persistence_diagram}
\alias{plot.persistence_diagram}
\title{Plot for \code{\link{persistence_diagram}} objects}
\usage{
\method{plot}{persistence_diagram}(
  x,
  dimension = NULL,
  alpha = 0.6,
  max_intervals = 20000,
  legend = FALSE,
  greyblock = TRUE,
  type = c("barcode", "diagram", "density"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{persistence_diagram}}.}

\item{dimension}{An integer value specifying the homology dimension to
visualize. Defaults to \code{NULL} in which case the dimension is retrieved
directly in the \link{persistence_diagram} object.}

\item{alpha}{A numeric value between 0 and 1 specifying the transparency of
points and lines in the plot. Defaults to \code{0.6}.}

\item{max_intervals}{An integer value specifying the maximal number of
intervals to display. Selected intervals are those with the longest
lifetime. Set it to \code{0} to see them all. Defaults \code{20000L}.}

\item{legend}{A boolean value specifying whether to display the legend about
the homology dimension(s). Defaults to \code{FALSE}.}

\item{greyblock}{A boolean value specifying whether to display a grey lower
triangle in the diagram representation for nicer output. Defaults to
\code{TRUE}.}

\item{type}{A string specifyfing the type of representation. Choices are
\code{"barcode"}, \code{"diagram"} or \code{"density"}. Defaults to \code{"barcode"}.}

\item{...}{Other parameters to be passed on to next methods.}
}
\description{
This function creates a visualization of a persistence diagram \strong{without}
returning the corresponding \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\examples{
\dontshow{if (requireNamespace("tibble", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pd <- as_persistence_diagram(tibble::tibble(
  birth = 0,
  death = 1,
  dimension = 0
))
plot(pd)
\dontshow{\}) # examplesIf}
}
