% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-metrics.R
\name{WassersteinDistance}
\alias{WassersteinDistance}
\title{Metrics: Wasserstein Distance}
\description{
Computes the Wasserstein distance matrix from a list of
persistence diagrams.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
dis <- WassersteinDistance$new()
dis$apply(dgm, dgm)
dis$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:MetricStep]{rgudhi::MetricStep}} -> \code{WassersteinDistance}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WassersteinDistance-new}{\code{WassersteinDistance$new()}}
\item \href{#method-WassersteinDistance-clone}{\code{WassersteinDistance$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="apply"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-apply'><code>rgudhi::MetricStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="fit"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-fit'><code>rgudhi::MetricStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="fit_transform"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-fit_transform'><code>rgudhi::MetricStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="transform"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-transform'><code>rgudhi::MetricStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WassersteinDistance-new"></a>}}
\if{latex}{\out{\hypertarget{method-WassersteinDistance-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{WassersteinDistance}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WassersteinDistance$new(
  order = 1,
  internal_p = Inf,
  mode = c("hera", "pot"),
  delta = 0.01,
  n_jobs = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order}}{An integer value specifying the exponent of the Wasserstein
distance. Defaults to \code{1.0}.}

\item{\code{internal_p}}{An integer value specifying the ground metric on the
(upper-half) plane (i.e. the norm \eqn{\ell_p} in \eqn{R^2}). Defaults
to \code{Inf}.}

\item{\code{mode}}{A string specifying the method for computing the Wasserstein
distance. Choices are either \code{"pot"} or \code{"hera"}. Defaults to \code{"hera"}.}

\item{\code{delta}}{A numeric value specifying the relative error
\eqn{1+\delta}. Defaults to \code{0.01}. Used only if \code{mode == "hera"}.}

\item{\code{n_jobs}}{An integer value specifying the number of jobs to use for
the computation. Defaults to \code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{WassersteinDistance}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WassersteinDistance-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WassersteinDistance-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WassersteinDistance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
