% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{Tomato}
\alias{Tomato}
\title{Clustering: Tomato}
\description{
This clustering algorithm needs a neighborhood graph on the
points, and an estimation of the density at each point. A few possible
graph constructions and density estimators are provided for convenience,
but it is perfectly natural to provide your own.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(100)
cl <- Tomato$new()
cl$fit_predict(X)
cl$set_n_clusters(2)
cl$get_labels()
\dontshow{\}) # examplesIf}
}
\author{
Marc Glisse
}
\section{Super class}{
\code{rgudhi::PythonClass} -> \code{Tomato}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Tomato-new}{\code{Tomato$new()}}
\item \href{#method-Tomato-fit}{\code{Tomato$fit()}}
\item \href{#method-Tomato-fit_predict}{\code{Tomato$fit_predict()}}
\item \href{#method-Tomato-set_n_clusters}{\code{Tomato$set_n_clusters()}}
\item \href{#method-Tomato-get_n_clusters}{\code{Tomato$get_n_clusters()}}
\item \href{#method-Tomato-set_merge_threshold}{\code{Tomato$set_merge_threshold()}}
\item \href{#method-Tomato-get_merge_threshold}{\code{Tomato$get_merge_threshold()}}
\item \href{#method-Tomato-get_labels}{\code{Tomato$get_labels()}}
\item \href{#method-Tomato-plot_diagram}{\code{Tomato$plot_diagram()}}
\item \href{#method-Tomato-clone}{\code{Tomato$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-new"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{Tomato}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$new(
  graph_type = c("knn", "radius", "manual"),
  density_type = c("logDTM", "DTM", "logKDE", "KDE", "manual"),
  n_clusters = NULL,
  merge_threshold = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graph_type}}{A string specifying the method to compute the
neighboring graph. Choices are \code{"knn"}, \code{"radius"} or \code{"manual"}.
Defaults to \code{"knn"}.}

\item{\code{density_type}}{A string specifying the choice of density estimator.
Choicea are \code{"logDTM"}, \code{"DTM"}, \code{"logKDE"} or \code{"manual"}. When you
have many points, \code{"KDE"} and \code{"logKDE"} tend to be slower. Defaults to
\code{"logDTM"}}

\item{\code{n_clusters}}{An integer value specifying the number of clusters.
Defaults to \code{NULL}, i.e. no merging occurs and we get the maximal
number of clusters.}

\item{\code{merge_threshold}}{A numeric value specifying the minimum prominence
of a cluster so it doesn’t get merged. Defaults to \code{NULL}, i.e. no
merging occurs and we get the maximal number of clusters.}

\item{\code{...}}{Extra parameters passed to \code{KNearestNeighbors} and
\code{DTMDensity}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{Tomato}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-fit"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-fit}{}}}
\subsection{Method \code{fit()}}{
Runs the Tomato algorithm on the provided data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$fit(X, y = NULL, weights = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Either a numeric matrix specifying the coordinates (in column)
of each point (in row) or a \strong{full} distance matrix if \code{metric == "precomputed"} or a list of neighbors for each point if \code{graph_type == "manual"}. The number of points is currently limited to about 2
billion.}

\item{\code{y}}{Not used, present here for API consistency with
\strong{scikit-learn} by convention.}

\item{\code{weights}}{A numeric vector specifying a density estimate at each
point. Used only if \code{density_type == "manual"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated \code{\link{Tomato}} class itself invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-fit_predict"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-fit_predict}{}}}
\subsection{Method \code{fit_predict()}}{
Runs the Tomato algorithm on the provided data \strong{and}
returns the class memberships.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$fit_predict(X, y = NULL, weights = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Either a numeric matrix specifying the coordinates (in column)
of each point (in row) or a \strong{full} distance matrix if \code{metric == "precomputed"} or a list of neighbors for each point if \code{graph_type == "manual"}. The number of points is currently limited to about 2
billion.}

\item{\code{y}}{Not used, present here for API consistency with
\strong{scikit-learn} by convention.}

\item{\code{weights}}{A numeric vector specifying a density estimate at each
point. Used only if \code{density_type == "manual"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An integer vector storing the class memberships.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-set_n_clusters"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-set_n_clusters}{}}}
\subsection{Method \code{set_n_clusters()}}{
Sets the number of clusters which automatically adjusts
class memberships.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$set_n_clusters(n_clusters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_clusters}}{An integer value specifying the number of clusters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated \code{\link{Tomato}} class itself invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-get_n_clusters"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-get_n_clusters}{}}}
\subsection{Method \code{get_n_clusters()}}{
Gets the number of clusters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$get_n_clusters()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of clusters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-set_merge_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-set_merge_threshold}{}}}
\subsection{Method \code{set_merge_threshold()}}{
Sets the threshold for merging clusters which automatically
adjusts class memberships.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$set_merge_threshold(merge_threshold)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{merge_threshold}}{A numeric value specifying the threshold for
merging clusters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated \code{\link{Tomato}} class itself invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-get_merge_threshold"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-get_merge_threshold}{}}}
\subsection{Method \code{get_merge_threshold()}}{
Gets the threshold for merging clusters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$get_merge_threshold()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The threshold for merging clusters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-get_labels"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-get_labels}{}}}
\subsection{Method \code{get_labels()}}{
Gets the class memberships.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$get_labels()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer vector storing the class memberships.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-plot_diagram"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-plot_diagram}{}}}
\subsection{Method \code{plot_diagram()}}{
Computes the persistence diagram of the merge tree of the
initial clusters. This is a convenient graphical tool to help decide
how many clusters we want.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$plot_diagram()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tomato-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Tomato-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tomato$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
