% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-tangential.R
\name{TangentialComplex}
\alias{TangentialComplex}
\title{R6 Class for Tangential Complex}
\description{
A Tangential Delaunay complex is a simplicial complex designed
to reconstruct a \eqn{k}-dimensional manifold embedded in
\eqn{d}-dimensional Euclidean space. The input is a point sample coming
from an unknown manifold. The running time depends only linearly on the
extrinsic dimension \eqn{d} and exponentially on the intrinsic dimension
\eqn{k}.
}
\details{
The \link{TangentialComplex} class represents a tangential complex. After
the computation of the complex, an optional post-processing called
perturbation can be run to attempt to remove inconsistencies.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
tc
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
tc$compute_tangential_complex()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
st <- tc$compute_tangential_complex()$create_simplex_tree()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
st <- tc$compute_tangential_complex()$create_simplex_tree()
tc$get_point(1)
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
tc$compute_tangential_complex()
tc$num_inconsistent_simplices()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
tc$compute_tangential_complex()
tc$num_inconsistent_stars()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
tc$compute_tangential_complex()
tc$num_simplices()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
tc$compute_tangential_complex()
tc$num_vertices()
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
tc <- TangentialComplex$new(points = X, intrinsic_dim = 1)
tc$set_max_squared_edge_length(1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other filtrations and reconstructions: 
\code{\link{AlphaComplex}},
\code{\link{RipsComplex}},
\code{\link{WitnessComplex}}
}
\author{
Clément Jamin
}
\concept{filtrations and reconstructions}
\section{Super class}{
\code{rgudhi::PythonClass} -> \code{TangentialComplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TangentialComplex-new}{\code{TangentialComplex$new()}}
\item \href{#method-TangentialComplex-compute_tangential_complex}{\code{TangentialComplex$compute_tangential_complex()}}
\item \href{#method-TangentialComplex-create_simplex_tree}{\code{TangentialComplex$create_simplex_tree()}}
\item \href{#method-TangentialComplex-get_point}{\code{TangentialComplex$get_point()}}
\item \href{#method-TangentialComplex-num_inconsistent_simplices}{\code{TangentialComplex$num_inconsistent_simplices()}}
\item \href{#method-TangentialComplex-num_inconsistent_stars}{\code{TangentialComplex$num_inconsistent_stars()}}
\item \href{#method-TangentialComplex-num_simplices}{\code{TangentialComplex$num_simplices()}}
\item \href{#method-TangentialComplex-num_vertices}{\code{TangentialComplex$num_vertices()}}
\item \href{#method-TangentialComplex-set_max_squared_edge_length}{\code{TangentialComplex$set_max_squared_edge_length()}}
\item \href{#method-TangentialComplex-clone}{\code{TangentialComplex$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-new}{}}}
\subsection{Method \code{new()}}{
\code{TangentialComplex} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$new(points, intrinsic_dim = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{points}}{Either a character string specifying the path to an OFF
file which the points can be read from or a numeric matrix or list of
numeric vectors specifying the points directly.}

\item{\code{intrinsic_dim}}{An integer value specifying the intrinsic dimension
of the manifold. This is nedded when points are provided as a numeric
matrix or a list of numeric vectors. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{TangentialComplex}} object storing the tangential
complex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-compute_tangential_complex"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-compute_tangential_complex}{}}}
\subsection{Method \code{compute_tangential_complex()}}{
This function computes the tangential complex.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$compute_tangential_complex()}\if{html}{\out{</div>}}
}

\subsection{Details}{
In debug mode, it may raise a \code{ValueError} if the computed star
dimension is too low. Try to set a bigger maximal edge length value via
the \verb{$set_max_squared_edge_length()} method if this happens.
}

\subsection{Returns}{
The updated \code{\link{TangentialComplex}} class itself
invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-create_simplex_tree"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-create_simplex_tree}{}}}
\subsection{Method \code{create_simplex_tree()}}{
Exports the complex into a simplex tree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$create_simplex_tree()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link{SimplexTree}} object storing the computed simplex
tree.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-get_point"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-get_point}{}}}
\subsection{Method \code{get_point()}}{
This function returns the point corresponding to a given
vertex from the \code{\link{SimplexTree}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$get_point(vertex)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vertex}}{An integer value specifying the desired vertex.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector storing the point corresponding to the input
vertex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-num_inconsistent_simplices"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-num_inconsistent_simplices}{}}}
\subsection{Method \code{num_inconsistent_simplices()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$num_inconsistent_simplices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer value storing the number of inconsistent simplicies.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-num_inconsistent_stars"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-num_inconsistent_stars}{}}}
\subsection{Method \code{num_inconsistent_stars()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$num_inconsistent_stars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer value storing the number of stars containing at least
one inconsistent simplex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-num_simplices"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-num_simplices}{}}}
\subsection{Method \code{num_simplices()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$num_simplices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer value storing the total number of simplices in stars
(including duplicates that appear in several stars).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-num_vertices"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-num_vertices}{}}}
\subsection{Method \code{num_vertices()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$num_vertices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer value storing the number of vertices.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-set_max_squared_edge_length"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-set_max_squared_edge_length}{}}}
\subsection{Method \code{set_max_squared_edge_length()}}{
Sets the maximal possible squared edge length for the edges
in the triangulations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$set_max_squared_edge_length(max_squared_edge_length)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_squared_edge_length}}{A numeric value specifying the maximal
possible squared edge length.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If the maximal edge length value is too low, the
\verb{$compute_tangential_complex()} method will throw an exception in debug
mode.
}

\subsection{Returns}{
The updated \code{\link{TangentialComplex}} class itself
invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TangentialComplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TangentialComplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TangentialComplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
