% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-kernel-methods.R
\name{KernelRepresentationStep}
\alias{KernelRepresentationStep}
\title{Kernel Representation Step}
\description{
Kernel Representation Step

Kernel Representation Step
}
\author{
Mathieu Carrière
}
\keyword{internal}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{KernelRepresentationStep}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KernelRepresentationStep-apply}{\code{KernelRepresentationStep$apply()}}
\item \href{#method-KernelRepresentationStep-fit}{\code{KernelRepresentationStep$fit()}}
\item \href{#method-KernelRepresentationStep-transform}{\code{KernelRepresentationStep$transform()}}
\item \href{#method-KernelRepresentationStep-fit_transform}{\code{KernelRepresentationStep$fit_transform()}}
\item \href{#method-KernelRepresentationStep-clone}{\code{KernelRepresentationStep$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelRepresentationStep-apply"></a>}}
\if{latex}{\out{\hypertarget{method-KernelRepresentationStep-apply}{}}}
\subsection{Method \code{apply()}}{
Applies the class on a single persistence diagram and
outputs the result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelRepresentationStep$apply(diag1, diag2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{diag1}}{A 2-column \link[tibble:tibble]{tibble::tibble} specifying a persistence diagram.}

\item{\code{diag2}}{A 2-column \link[tibble:tibble]{tibble::tibble} specifying a persistence diagram.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric value storing the kernel-induced inner product between
the two input diagrams.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelRepresentationStep-fit"></a>}}
\if{latex}{\out{\hypertarget{method-KernelRepresentationStep-fit}{}}}
\subsection{Method \code{fit()}}{
Fits the class on a sample of persistence diagrams.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelRepresentationStep$fit(X, y = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{A list of 2-column \link[tibble:tibble]{tibble::tibble}s specifying a sample of
persistence diagrams.}

\item{\code{y}}{An integer vector specifying persistence diagram labels (unused for
now).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The class itself invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelRepresentationStep-transform"></a>}}
\if{latex}{\out{\hypertarget{method-KernelRepresentationStep-transform}{}}}
\subsection{Method \code{transform()}}{
Applies the class on a sample of persistence diagrams.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelRepresentationStep$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{A list of 2-column \link[tibble:tibble]{tibble::tibble}s specifying a sample of
persistence diagrams.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric matrix of shape \eqn{n_\mathrm{out} \times
  n_\mathrm{in}} storing the kernel-induced inner product between the
\eqn{n_\mathrm{out}} persistence diagrams passed to the \verb{$transform()}
method and the \eqn{n_\mathrm{in}} persistence diagrams passed to the
\verb{$fit()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelRepresentationStep-fit_transform"></a>}}
\if{latex}{\out{\hypertarget{method-KernelRepresentationStep-fit_transform}{}}}
\subsection{Method \code{fit_transform()}}{
Applies sequentially the \verb{$fit()} and \verb{$transform()} methods
on a sample of persistence diagrams in a more efficient way than
calling them directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelRepresentationStep$fit_transform(X, y = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{A list of 2-column \link[tibble:tibble]{tibble::tibble}s specifying a sample of
persistence diagrams.}

\item{\code{y}}{An integer vector specifying persistence diagram labels (unused for
now).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric matrix of shape \eqn{n \times n} storing the
kernel-induced inner product between the \eqn{n} persistence diagrams
passed to both the \verb{$fit()} and \verb{$transform()} methods.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelRepresentationStep-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KernelRepresentationStep-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelRepresentationStep$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
