# Getting help with `rgl`

Before filing an issue, there are a few places to explore and pieces to put together to make the process as smooth as possible.

## Make a reprex

Start by making a minimal **repr**oducible **ex**ample using the  [reprex](https://reprex.tidyverse.org/) package. 
If you haven't heard of or used the `reprex` package before,
you'll already have gained by learning it.
`reprex` will make all of your R-question-asking endeavors
easier (which is an amazing ROI for the five to ten minutes
it'll take you to learn what it's all about).

## Where to ask?

Armed with your reprex, the next step is to figure out [where to ask](https://www.tidyverse.org/help/#where-to-ask). 

*   If it's a question: start with [stackoverflow](https://stackoverflow.com/).  
You can use `rgl` as a tag in your question and lots of
knowledgeable people will see it. 

*   If it's a bug: you're in the right place, [file an issue](https://github.com/dmurdoch/rgl/issues/new).  
  
*   If you're not sure: let the community help you figure it out! 
    If your problem _is_ a bug or a feature request, you can easily return here and report it. 

Before opening a new issue, be sure to [search issues and pull requests](https://github.com/dmurdoch/rgl/issues) to make sure the bug hasn't been reported and/or already fixed in the development version. 
By default, the search will be pre-populated with `is:issue is:open`. 
You can [edit the qualifiers](https://help.github.com/articles/searching-issues-and-pull-requests/)  (e.g. `is:pr`, `is:closed`) as needed. 
For example, you'd simply remove `is:open` to search _all_ issues in the repo, open or closed.

## What about a PR?

Pull requests are welcome.  We don't require copyright transfer,
but we do need you to allow us to license your contribution 
under `rgl`'s GPL license.

## What happens next?

Development of `rgl` tends to be very bursty, so you shouldn't
worry if you don't get an immediate response.
This makes a good reprex particularly important because it might
be several weeks (or months!) between your initial report and
when we start working on it. 
If we can’t reproduce the bug, we can’t fix it!

## Credits

This page is based on one found in a [tidyverse](https://github.com/tidyverse) project.  Thanks to 
the original authors!
