% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_data_field_children.R
\name{add_data_field_children}
\alias{add_data_field_children}
\title{Add 'Interval' and 'Value' child elements to a given DataField element in a
given PMML file.}
\usage{
add_data_field_children(
  xml_model = NULL,
  field = NULL,
  intervals = NULL,
  values = NULL,
  namespace = "4_4",
  ...
)
}
\arguments{
\item{xml_model}{The PMML model in a XML node format. If the model is a text
file, it should be converted to an XML node, for example, using the
file_to_xml_node function.}

\item{field}{The field to which the attributes are to be added. This is used
when the attributes are a vector of name-value pairs, intended for this one
field.}

\item{intervals}{The 'Interval' elements given as a list}

\item{values}{The 'Value' elements given as a list.}

\item{namespace}{The namespace of the PMML model. This is frequently also
the PMML version of the model.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{XMLNode} as that defined by the \pkg{XML} package.
This represents the top level, or root node, of the XML document and is of
type PMML. It can be written to file with \code{saveXML}.
}
\description{
Add 'Interval' and 'Value' child elements to a given DataField element in a
given PMML file.
}
\details{
The PMML format allows a DataField element to have 'Interval' and 'Value'
child elements which although useful, may not always be present in a PMML
model. This function allows one to take an existing PMML file and add these
elements to the DataFields.

The 'Interval' elements or the 'Value' elements can be typed in, but more
conveniently created by using the helper functions 'make_intervals' and
'MakeValues'. This function can then add these extra information to the
PMML.
}
\examples{
# Make a sample model:
fit <- lm(Sepal.Length ~ ., data = iris[, -5])
fit_pmml <- pmml(fit)

# The resulting model has data fields but with no 'Interval' or Value'
# elements. This object is already an xml node (not an external text
# file), so there is no need to convert it to an xml node object.

# Add an 'Interval' element node by typing it in
fit_pmml_2 <- add_data_field_children(fit_pmml,
  field = "Sepal.Length",
  intervals = list(newXMLNode("Interval",
    attrs = c(closure = "openClosed", rightMargin = 3)
  ))
)

# Use helper functions to create list of 'Interval' and 'Value'
# elements. We define the 3 Intervals as ,1]  (1,2)  and [2,
mi <- make_intervals(
  list("openClosed", "openOpen", "closedOpen"),
  list(NULL, 1, 2), list(1, 2, NULL)
)

# Define 3 values, none with a 'displayValue' attribute and 1 value
# defined as 'invalid'. The 2nd one is 'valid' by default.
mv <- make_values(
  list(1.1, 2.2, 3.3), list(NULL, NULL, NULL),
  list("valid", NULL, "invalid")
)

# As an example, apply these to the Sepal.Length field:
fit_pmml_3 <- add_data_field_children(fit_pmml, field = "Sepal.Length", intervals = mi, values = mv)

# Only defined 'Interval's:
fit_pmml_3 <- add_data_field_children(fit_pmml, field = "Sepal.Length", intervals = mi)
}
\author{
Tridivesh Jena
}
\keyword{interface}
