% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpnorm.R
\name{xpnorm}
\alias{xpnorm}
\alias{xqnorm}
\alias{xcnorm}
\title{Augmented versions of pnorm and qnorm}
\usage{
xpnorm(
  q,
  mean = 0,
  sd = 1,
  plot = TRUE,
  verbose = TRUE,
  invisible = FALSE,
  digits = 4,
  lower.tail = TRUE,
  log.p = FALSE,
  xlim = mean + c(-4, 4) * sd,
  ylim = c(0, 1.4 * dnorm(mean, mean, sd)),
  manipulate = FALSE,
  ...,
  return = c("value", "plot")
)

xqnorm(
  p,
  mean = 0,
  sd = 1,
  plot = TRUE,
  verbose = TRUE,
  digits = getOption("digits"),
  lower.tail = TRUE,
  log.p = FALSE,
  xlim,
  ylim,
  invisible = FALSE,
  ...,
  return = c("value", "plot"),
  pattern = c("stripes", "rings")
)

xcnorm(
  p,
  mean = 0,
  sd = 1,
  plot = TRUE,
  verbose = TRUE,
  digits = getOption("digits"),
  lower.tail = TRUE,
  log.p = FALSE,
  xlim,
  ylim,
  invisible = FALSE,
  ...,
  return = c("value", "plot"),
  pattern = "rings"
)
}
\arguments{
\item{q}{quantile}

\item{mean, sd}{parameters of normal distribution.}

\item{plot}{logical.  If TRUE, show an illustrative plot.}

\item{verbose}{logical.  If TRUE, display verbose output.}

\item{invisible}{logical.  If TRUE, return value invisibly.}

\item{digits}{number of digits to display in output.}

\item{lower.tail}{logical.  If FALSE, use upper tail probabilities.}

\item{log.p}{logical.  If TRUE, uses the log of probabilities.}

\item{xlim, ylim}{limits for plotting.}

\item{manipulate}{logical.  If TRUE and in RStudio,
then sliders are added for interactivity.}

\item{\dots}{additional arguments.}

\item{return}{If \code{"plot"}, return a plot.  If \code{"values"}, return a vector of numerical values.}

\item{p}{probability}

\item{pattern}{One of \code{"stripes"} or \code{"rings"}.  In the latter case, pairs of regions
(from inside to outside) are grouped together for coloring and probability calculation.}
}
\description{
These functions behave similarly to the functions with the initial \code{x}
removed from their names but add more verbose output and graphics.
}
\examples{
xpnorm(650, 500, 100)
xqnorm(.75, 500, 100)
xpnorm(-3:3, return = "plot", system = "gg") |> 
  gf_labs(title = "My Plot", x = "") |> 
  gf_theme(theme_bw())

\dontrun{
if (rstudio_is_available() & require(manipulate)) {
  manipulate(xpnorm(score, 500, 100, verbose = verbose),
    score = slider(200, 800),
	   verbose = checkbox(TRUE, label = "Verbose Output")
  )
}
}
}
\seealso{
\code{\link[=histogram]{histogram()}},
\code{\link[=chisq.test]{chisq.test()}},
\code{\link[=pnorm]{pnorm()}},
\code{\link[=qnorm]{qnorm()}},
\code{\link[=qqmath]{qqmath()}}, and
\code{\link[=plot]{plot()}}.
}
