% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.update.R
\name{mplus.update}
\alias{mplus.update}
\title{Mplus Input Updating}
\usage{
mplus.update(x, update, file = "Mplus_Input_Update.inp",
             replace.inp = TRUE, mplus.run = TRUE,
             show.out = FALSE, replace.out = c("always", "never", "modified"),
             print = c("all", "input", "result"),
             input = c("all", "default", "data", "variable", "define",
                       "analysis", "model", "montecarlo", "mod.pop", "mod.cov",
                       "mod.miss", "message"),
             result = c("all", "default", "summary.analysis.short",
                        "summary.data.short", "random.starts", "summary.fit",
                        "mod.est", "fit", "class.count", "classif",
                        "mod.result", "total.indirect"),
             exclude = NULL, variable = FALSE, not.input = TRUE, not.result = TRUE,
             write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{\code{misty.object} object of type \code{mplus}.}

\item{update}{a character vector containing the updated input command
sections.}

\item{file}{a character string indicating the name of the updated Mplus
input file with or without the file extension \code{.inp},
e.g., \code{"Mplus_Input_Update.inp"} or \code{"Mplus_Input_Update"}.}

\item{replace.inp}{logical: if \code{TRUE} (default), an existing input
file will be replaced.}

\item{mplus.run}{logical: if \code{TRUE}, the input file specified in the
argument \code{file} containing the input text specified
in the argument \code{x} is run using the \code{mplus.run}
function.}

\item{show.out}{logical: if \code{TRUE}, estimation output (\code{TECH8})
is show on the R console. Note that if run within Rgui,
output will display within R, but if run via Rterm, a
separate window will appear during estimation.}

\item{replace.out}{a character string for specifying three settings:
\code{"always"} (default), which runs all models, regardless
of whether an output file for the model exists, \code{"never"},
which does not run any model that has an existing output file,
and \code{"modified"}, which only runs a model if the
modified date for the input file is more recent than the
output file modified date.}

\item{print}{a character vector indicating which results to show, i.e.
\code{"all"} (default) for all results \code{"input"} for
input command sections, and \code{"result"} for result sections.}

\item{input}{a character vector specifiying Mplus input command sections
included in the output (see 'Details' in the \code{\link{mplus.print}}
function).}

\item{result}{a character vector specifiying Mplus result sections included
in the output (see 'Details' in the \code{\link{mplus.print}}
function).}

\item{exclude}{a character vector specifiying Mplus input command or result
sections excluded from the output (see 'Details' in the
\code{\link{mplus.print}} function).}

\item{variable}{logical: if \code{TRUE}, names of the variables in the data
set (\code{NAMES ARE}) specified in the \code{VARIABLE:}
command section are shown. By default, names of the variables
in the data set are excluded from the output unless all variables
are used in the analysis (i.e., no \code{USEVARIABLES} command
specified in the Mplus input file).}

\item{not.input}{logical: if \code{TRUE} (default), character vector indicating
the input commands not requested are shown on the console.}

\item{not.result}{logical: if \code{TRUE} (default), character vector indicating
the result sections not requested are shown on the console.}

\item{write}{a character string naming a file for writing the output into
a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}).}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console by using the function \code{mplus.print}.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{a character vector containing the Mplus input text}
\item{\code{args}}{specification of function arguments}
\item{\code{input}}{list with input command sections}
\item{\code{write}}{write command sections}
\item{\code{result}}{list with input command sections (\code{input}) and
                     result sections (\code{input})}
}
\description{
This function updates specific input command sections of a \code{misty.object}
of type \code{mplus} to create an updated Mplus input file, run the updated
input file by using the \code{mplus.run()} function, and print the updated Mplus
output file by using the \code{mplus.print()} function.
}
\details{
\describe{
\item{\strong{The \code{...} Specification}}{The \code{...} Specification
can be used to update specific options in the \code{VARIABLE} and \code{ANALYSIS}
section, while keeping all other options in the \code{misty.object} of type
\code{mplus} specified in the argument \code{x}. Note that the \code{...}
specification is only available for the \code{VARIABLE} and \code{ANALYSIS} section.}
\item{\strong{The \code{---;} Specification}}{can be used to remove entire sections
(e.g., \code{OUTPUT: ---;}) or options within the \code{VARIABLE:} and \code{ANALYSIS:}
section (e.g., \code{ANALYSIS: ESTIMATOR IS ---;}) from the Mplus input.}
\item{\strong{Comments in the Mplus Input}}{Comments in the Mplus Input can cause
problems when following keywords in uppercase, lower case, or mixed upper and lower
case letters are involved in the comments of the \code{VARIABLE} and \code{ANALYSIS}
section:
  \itemize{
     \item{\code{VARIABLE} section}: \code{"NAMES", "USEOBSERVATIONS", "USEVARIABLES",
     "MISSING", "CENSORED", "CATEGORICAL", "NOMINAL", "COUNT", "DSURVIVAL", "GROUPING",
     "IDVARIABLE", "FREQWEIGHT", "TSCORES", "AUXILIARY", "CONSTRAINT", "PATTERN",
     "STRATIFICATION", "CLUSTER", "WEIGHT", "WTSCALE", "BWEIGHT", "B2WEIGHT",
     "B3WEIGHT", "BWTSCALE", "REPWEIGHTS", "SUBPOPULATION", "FINITE", "CLASSES",
     "KNOWNCLASS", "TRAINING", "WITHIN", "BETWEEN", "SURVIVAL", "TIMECENSORED",
     "LAGGED"}, or \code{"TINTERVAL"}.
     \item{\code{ANALYSIS} section}: \code{"TYPE", "ESTIMATOR", "MODEL", "ALIGNMENT",
     "DISTRIBUTION", "PARAMETERIZATION", "LINK", "ROTATION", "ROWSTANDARDIZATION",
     "PARALLEL", "REPSE", "BASEHAZARD", "CHOLESKY", "ALGORITHM", "INTEGRATION",
     "MCSEED", "ADAPTIVE", "INFORMATION", "BOOTSTRAP", "LRTBOOTSTRAP", "STARTS",
     "STITERATIONS", "STCONVERGENCE", "STSCALE", "STSEED", "OPTSEED", "K-1STARTS",
     "LRTSTARTS", "RSTARTS", "ASTARTS", "H1STARTS", "DIFFTEST", "MULTIPLIER",
     "COVERAGE", "ADDFREQUENCY", "ITERATIONS", "SDITERATIONS", "H1ITERATIONS",
     "MITERATIONS", "MCITERATIONS", "MUITERATIONS", "RITERATIONS", "AITERATIONS",
     "CONVERGENCE", "H1CONVERGENCE", "LOGCRITERION", "RLOGCRITERION", "MCONVERGENCE",
     "MCCONVERGENCE", "MUCONVERGENCE", "RCONVERGENCE", "ACONVERGENCE", "MIXC",
     "MIXU", "LOGHIGH", "LOGLOW", "UCELLSIZE", "VARIANCE", "SIMPLICITY", "TOLERANCE",
     "METRIC", "MATRIX", "POINT", "CHAINS", "BSEED", "STVALUES", "PREDICTOR",
     "ALGORITHM", "BCONVERGENCE", "BITERATIONS", "FBITERATIONS", "THIN",
     "MDITERATIONS", "KOLMOGOROV", "PRIOR", "INTERACTIVE"}, or \code{"PROCESSORS"}.
  }
Note that it is recommended to remove all comments in the \code{VARIABLE} and
\code{VARIABLE} section when the function crashes.
}
}
}
\examples{
\dontrun{
#----------------------------------------------------------------------------
# Example 1: Update VARIABLE and MODEL section

# Write Mplus Data File
write.mplus(ex3_1, file = "ex3_1.dat")

# Specify Mplus input
input <- '
DATA:     FILE IS ex3_1.dat;
VARIABLE: NAMES ARE y1 x1 x3;
MODEL:    y1 ON x1 x3;
OUTPUT:   SAMPSTAT;
'

# Run Mplus input
mod0 <- mplus(input, file = "ex3_1.inp")

# Update VARIABLE and MODEL section
update1 <- '
VARIABLE: ...
          USEVARIABLES ARE y1 x1;
MODEL:    y1 ON x1;
'

# Run updated Mplus input
mod1 <- mplus.update(mod1, update1, file = "ex3_1_update1.inp")

#----------------------------------------------------------------------------
# Example 2: Update ANALYSIS section

# Update ANALYSIS section
update2 <- '
ANALYSIS: ESTIMATOR IS MLR;
'

# Run updated Mplus input
mod2 <- mplus.update(mod2, update2, file = "ex3_1_update2.inp")

#----------------------------------------------------------------------------
# Example 3: Remove OUTPUT section

Remove OUTPUT section
update3 <- '
OUTPUT: ---;
'

# Run updated Mplus input
mod3 <- mplus.update(mod3, update3, file = "ex3_1_update3.inp")
}
}
\references{
Muthen, L. K., & Muthen, B. O. (1998-2017). \emph{Mplus User's Guide} (8th ed.).
Muthen & Muthen.
}
\seealso{
\code{\link{read.mplus}}, \code{\link{write.mplus}}, \code{\link{mplus.print}},
\code{\link{mplus}}, \code{\link{mplus.run}}, \code{\link{mplus.lca}}
}
\author{
Takuya Yanagida
}
