% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bysmxmss.R
\name{Bysmxmss}
\alias{Bysmxmss}
\title{Bayesian mixed model with random intercepts and random slopes for high dimensional longitudinal data with batch size.}
\usage{
Bysmxmss(m, tmax, timepoints, group, chains, iter, data)
}
\arguments{
\item{m}{Starting number of column from where repeated observations begin}

\item{tmax}{Maximum batch of visits considered as repeated measurements}

\item{timepoints}{Timepoint information on which repeadted observations were taken}

\item{group}{A categorical variable either 0 or 1. i.e. Gender - 1 male and 0 female}

\item{chains}{Number of MCMC chains to be performed}

\item{iter}{Number of iterations to be performed}

\item{data}{High dimensional longitudinal data}
}
\value{
Gives posterior means, standard deviation.
}
\description{
Bayesian mixed effect model with random intercept and slopes. Data longitudinally measured missing value and having batched
information.
Fits using MCMC on longitudinal data set
}
\examples{
##
data(repdat)
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2013). Bayesian data analysis. CRC press.

Fitzmaurice, G. M., Laird, N. M., & Ware, J. H. (2012). Applied longitudinal analysis (Vol. 998). John Wiley & Sons.
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
