% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bysmixed.R
\name{Bysmixed}
\alias{Bysmixed}
\title{Bayesian mixed effect model with MCMC}
\usage{
Bysmixed(m, n, t, group, chains, n.adapt, data)
}
\arguments{
\item{m}{Starting number of column from where repeated observations begin}

\item{n}{Ending number of columns till where the repeated observations ends}

\item{t}{Timepoint information on which repeadted observations were taken}

\item{group}{A categorical variable either 0 or 1. i.e. Gender - 1 male and 0 female}

\item{chains}{Number of MCMC chains to be performed}

\item{n.adapt}{Number of iterations to run in the JAGS adaptive phase.}

\item{data}{High dimensional longitudinal data}
}
\value{
Gives posterior means, standard deviation.
}
\description{
Bayesian mixed effect model with random intercepts and random slopes.
Fits using MCMC on longitudinal data set.
}
\examples{
##
data(repdata)
Bysmixed(m=4,n=7,t="Age",group="Gender",chains=4,n.adapt=100,repdata)
##
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2013). Bayesian data analysis. CRC press.

Fitzmaurice, G. M., Laird, N. M., & Ware, J. H. (2012). Applied longitudinal analysis (Vol. 998). John Wiley & Sons.
}
\author{
Atanu Bhattacharjee, Akash Pawar and Bhrigu Kumar Rajbongshi
}
