% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{convert_chunk_header}
\alias{convert_chunk_header}
\title{Convert the in-header chunk option syntax to the in-body syntax}
\usage{
convert_chunk_header(
  input,
  output = NULL,
  type = c("multiline", "wrap", "yaml"),
  width = 0.9 * getOption("width")
)
}
\arguments{
\item{input}{File path to the document with code chunks to convert.}

\item{output}{The default \code{NULL} will output to console. Other values
can be a file path to write the converted content into or a function which
takes \code{input} as argument and returns a file path to write into (e.g.,
\code{output = identity} to overwrite the input file).}

\item{type}{This determines how the in-body options will be formatted.
\code{"mutiline"} (the default, except for \file{qmd} documents, for which
the default is \code{"yaml"}) will write each chunk option on a separate
line. Long chunk option values will be wrapped onto several lines, and you
can use \code{width = 0} to keep one line per option only. \code{"wrap"}
will wrap all chunk options together using
\code{\link[base:strwrap]{base::strwrap}()}. \code{"yaml"} will convert
chunk options to YAML.}

\item{width}{An integer passed to \code{base::strwrap()} for \code{type =
"wrap"} and \code{type = "multiline"}. If set to \code{0}, deactivate the
wrapping (for \code{type = "multiline"} only).}
}
\value{
A character vector of converted \code{input} when \code{output =
  NULL}. The output file path with converted content otherwise.
}
\description{
This is a helper function for moving chunk options from the chunk header to
the chunk body using the new syntax.
}
\note{
Learn more about the new chunk option syntax in
  \url{https://yihui.org/en/2022/01/knitr-news/}
}
\section{About \pkg{knitr} option syntax}{


Historical chunk option syntax have chunk option in the chunk header using
valid R syntax. This is an example for \verb{.Rmd} document
\preformatted{
```\{r, echo = FALSE, fig.width: 10\}
```
}

New syntax allows to pass option inside the chunk using several variants
\itemize{
\item Passing options one per line using valid R syntax. This corresponds to \code{convert_chunk_header(type = "multiline")}.
\preformatted{
```\{r\}
#| echo = FALSE,
#| fig.width = 10
```
}

\item Passing option part from header in-chunk with several line if wrapping is
needed. This corresponds to \code{convert_chunk_header(type = "wrap")}
\preformatted{
```\{r\}
#| echo = FALSE, fig.width = 10
```
}
\item Passing options key value pairs in-chunk using YAML syntax. Values are no
more R expression but valid YAML syntax. This corresponds to
\code{convert_chunk_header(type = "yaml")} (not implement yet).
\preformatted{```\{r\}
#| echo: false,
#| fig.width: 10
```
}
}
}

\examples{
knitr_example = function(...) system.file("examples", ..., package = "knitr")
# Convert a document for multiline type
convert_chunk_header(knitr_example("knitr-minimal.Rmd"))
# Convert a document for wrap type
convert_chunk_header(knitr_example("knitr-minimal.Rmd"), type = "wrap")
# Reduce default wrapping width
convert_chunk_header(knitr_example("knitr-minimal.Rmd"), type = "wrap", width = 0.6 *
    getOption("width"))
\dontrun{
# Explicitly name the output
convert_chunk_header("test.Rmd", output = "test2.Rmd")
# Overwrite the input
convert_chunk_header("test.Rmd", output = identity)
# Use a custom function to name the output
convert_chunk_header("test.Rmd", output = \(f) sprintf("\%s-new.\%s",
    xfun::sans_ext(f), xfun::file_ext(f)))
}
}
