% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.r
\name{glms}
\alias{glms}
\alias{reg.fit}
\alias{logistic.fit}
\alias{poisson.fit}
\title{Generalized Linear Model Fitters}
\usage{
reg.fit(x, y, maxiter = 100)

logistic.fit(x, y, maxiter = 100)

poisson.fit(x, y, maxiter = 100)
}
\arguments{
\item{x, y}{The input data \code{x} and response \code{y}.  Each must be a shaq, and
each must be distributed in an identical fashion.  See the details section
for more information.}

\item{maxiter}{The maximum number of iterations.}
}
\value{
The return is the output of an \code{optim()} call.
}
\description{
Linear regression (Gaussian GLM), logistic regression, and poisson
regression model fitters.
}
\details{
Each function is implemented with gradient descent using the conjugate
gradients method ("CG") of the \code{optim()} function.

Both of \code{x} and \code{y} must be distributed in an identical fashion.
This means that the number of rows owned by each MPI rank should match, and
the data rows \code{x} and response rows \code{y} should be aligned.
Additionally, each MPI rank should own at least one row.  Ideally they should
be load balanced, so that each MPI rank owns roughly the same amount of data.
}
\section{Communication}{

The communication consists of an allreduce of 1 double (the local
cost/objective function value) at each iteration of the optimization.
}

\examples{
\dontrun{
library(kazaam)
comm.set.seed(1234, diff=TRUE)

x = ranshaq(rnorm, 10, 3)
y = ranshaq(function(i) sample(0:1, size=i, replace=TRUE), 10)

fit = logistic.fit(x, y)
comm.print(fit)

finalize()
}

}
\references{
McCullagh, P. and Nelder, J.A., 1989. Generalized Linear Models, no. 37 in
Monograph on Statistics and Applied Probability.

Duda, R.O., Hart, P.E. and Stork, D.G., 1973. Pattern classification (pp.
526-528). Wiley, New York.
}
\seealso{
\code{\link{lm_coefs}}
}
