% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kostka.R
\name{symbolicSkewKostkaJackNumbers}
\alias{symbolicSkewKostkaJackNumbers}
\title{Skew Kostka-Jack numbers with symbolic Jack parameter}
\usage{
symbolicSkewKostkaJackNumbers(lambda, mu)
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}
}
\value{
The function returns a list. Each element of this
  list is a named list with two elements: an integer partition \eqn{\nu}
  in the field named \code{"nu"}, and the corresponding skew Kostka number
  \eqn{K_{\lambda/\mu,\nu}(\alpha)} in the field named \code{"value"}, a
  \code{ratioOfQsprays} object.
}
\description{
Skew Kostka-Jack numbers associated to a given skew partition
  with a symbolic Jack parameter.
}
\examples{
symbolicSkewKostkaJackNumbers(c(4,2,2), c(2,2))
}
