% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flaggedSchurPol.R
\name{flaggedSchurPol}
\alias{flaggedSchurPol}
\title{Flagged Schur polynomial}
\usage{
flaggedSchurPol(lambda, a, b)
}
\arguments{
\item{lambda}{integer partition}

\item{a, b}{lower bounds and upper bounds, weakly increasing vectors of
integers; \code{lambda}, \code{a} and \code{b} must have the same length}
}
\value{
A \code{qspray} polynomial.
}
\description{
Computes a flagged Schur polynomial (which is not symmetric
  in general). See
  \href{https://math.mit.edu/~apost/papers/degreeschub.pdf}{Chains in the Bruhat order}
  for the definition.
}
\examples{
lambda <- c(3, 2, 2)
n <- 3
a <- c(1, 1, 1); b <- c(n, n, n)
flaggedPoly <- flaggedSchurPol(lambda, a, b)
poly <- SchurPol(n, lambda)
flaggedPoly == poly # should be TRUE
}
