% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{iv-splits}
\alias{iv-splits}
\alias{iv_splits}
\alias{iv_identify_splits}
\alias{iv_locate_splits}
\title{Splits}
\usage{
iv_splits(x, ..., on = NULL)

iv_identify_splits(x, ..., on = NULL)

iv_locate_splits(x, ..., on = NULL)
}
\arguments{
\item{x}{\verb{[iv]}

An interval vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{on}{\verb{[vector / NULL]}

An optional vector of additional values to split on.

This should have the same type as \code{iv_start(x)}.}
}
\value{
\itemize{
\item For \code{iv_splits()}, an iv with the same type as \code{x}.
\item For \code{iv_identify_splits()}, a list-of containing ivs with the same size as
\code{x}.
\item For \code{iv_locate_splits()}, a two column data frame with a \code{key} column
of the same type as \code{x} and \code{loc} list-column containing integer vectors.
}
}
\description{
This family of functions revolves around splitting an iv on its endpoints,
which results in a new iv that is entirely disjoint (i.e. non-overlapping).
The intervals in the resulting iv are known as "splits".
\itemize{
\item \code{iv_splits()} computes the disjoint splits for \code{x}.
\item \code{iv_identify_splits()} identifies the splits that correspond to each
interval in \code{x}. It replaces \code{x} with a list of the same size where each
element of the list contains the splits that the corresponding interval in
\code{x} overlaps. This is particularly useful alongside \code{\link[tidyr:unnest]{tidyr::unnest()}}.
\item \code{iv_locate_splits()} returns a two column data frame with a \code{key} column
containing the result of \code{iv_splits()} and a \code{loc} list-column containing
integer vectors that map each interval in \code{x} to the splits that it overlaps.
}
}
\section{Graphical Representation}{


Graphically, generating splits looks like:

\figure{splits.png}
}

\examples{
library(tidyr)
library(dplyr)

# Guests to a party and their arrival/departure times
guests <- tibble(
  arrive = as.POSIXct(
    c("2008-05-20 19:30:00", "2008-05-20 20:10:00", "2008-05-20 22:15:00"),
    tz = "UTC"
  ),
  depart = as.POSIXct(
    c("2008-05-20 23:00:00", "2008-05-21 00:00:00", "2008-05-21 00:30:00"),
    tz = "UTC"
  ),
  name = list(
    c("Mary", "Harry"),
    c("Diana", "Susan"),
    "Peter"
  )
)

guests <- unnest(guests, name) \%>\%
  mutate(iv = iv(arrive, depart), .keep = "unused")

guests

# You can determine the disjoint intervals at which people
# arrived/departed with `iv_splits()`
iv_splits(guests$iv)

# Say you'd like to determine who was at the party at any given time
# throughout the night
guests <- mutate(guests, splits = iv_identify_splits(iv))
guests

# Unnest the splits to generate disjoint intervals for each guest
guests <- guests \%>\%
  unnest(splits) \%>\%
  select(name, splits)

guests

# Tabulate who was there at any given time
guests \%>\%
  summarise(n = n(), who = list(name), .by = splits)

# ---------------------------------------------------------------------------

x <- iv_pairs(c(1, 5), c(4, 9), c(12, 15))
x

# You can provide additional singular values to split on with `on`
iv_splits(x, on = c(2, 13))
}
