% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api.R
\name{hc_colors}
\alias{hc_colors}
\title{Colors options for highcharter objects}
\usage{
hc_colors(hc, colors)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{colors}{A vector of colors.}
}
\description{
An array containing the default colors for the chart's series. When all
colors are used, new colors are pulled from the start again.
}
\examples{

library(viridisLite)

cols <- viridis(3)
cols <- substr(cols, 0, 7)

highchart() \%>\%
  hc_add_series(data = sample(1:12)) \%>\%
  hc_add_series(data = sample(1:12) + 10) \%>\%
  hc_add_series(data = sample(1:12) + 20) \%>\%
  hc_colors(cols)
}
