% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior-samples.R
\name{posterior_samples}
\alias{posterior_samples}
\alias{posterior_samples.gam}
\title{Draw samples from the posterior distribution of an estimated model}
\usage{
posterior_samples(model, ...)

\method{posterior_samples}{gam}(
  model,
  n,
  data = newdata,
  seed = NULL,
  method = c("gaussian", "mh", "inla", "user"),
  n_cores = 1,
  burnin = 1000,
  thin = 1,
  t_df = 40,
  rw_scale = 0.25,
  freq = FALSE,
  unconditional = FALSE,
  weights = NULL,
  draws = NULL,
  ...,
  newdata = NULL,
  ncores = NULL
)
}
\arguments{
\item{model}{a fitted model of the supported types}

\item{...}{arguments passed to other methods. For \code{fitted_samples()}, these
are passed on to \code{\link[=predict.gam]{predict.gam()}}. For \code{posterior_samples()} these are
passed on to \code{fitted_samples()}. For \code{predicted_samples()} these are
passed on to the relevant \code{simulate()} method.}

\item{n}{numeric; the number of posterior samples to return.}

\item{data}{data frame; new observations at which the posterior draws
from the model should be evaluated. If not supplied, the data used to fit
the model will be used for \code{data}, if available in \code{model}.}

\item{seed}{numeric; a random seed for the simulations.}

\item{method}{character; which method should be used to draw samples from
the posterior distribution. \code{"gaussian"} uses a Gaussian (Laplace)
approximation to the posterior. \code{"mh"} uses a Metropolis Hastings sampler
that alternates t proposals with proposals based on a shrunken version of
the posterior covariance matrix. \code{"inla"} uses a variant of Integrated
Nested Laplace Approximation due to Wood (2019), (currently not
implemented). \code{"user"} allows for user-supplied posterior draws
(currently not implemented).}

\item{n_cores}{number of cores for generating random variables from a
multivariate normal distribution. Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}.
Parallelization will take place only if OpenMP is supported (but appears
to work on Windows with current \code{R}).}

\item{burnin}{numeric; number of samples to discard as the burnin draws.
Only used with \code{method = "mh"}.}

\item{thin}{numeric; the number of samples to skip when taking \code{n} draws.
Results in \code{thin * n} draws from the posterior being taken. Only used with
\code{method = "mh"}.}

\item{t_df}{numeric; degrees of freedome for t distribution proposals. Only
used with \code{method = "mh"}.}

\item{rw_scale}{numeric; Factor by which to scale posterior covariance
matrix when generating random walk proposals. Negative or non finite to
skip the random walk step. Only used with \code{method = "mh"}.}

\item{freq}{logical; \code{TRUE} to use the frequentist covariance matrix of
the parameter estimators, \code{FALSE} to use the Bayesian posterior
covariance matrix of the parameters.}

\item{unconditional}{logical; if \code{TRUE} (and \code{freq == FALSE}) then the
Bayesian smoothing parameter uncertainty corrected covariance matrix is
used, if available.}

\item{weights}{numeric; a vector of prior weights. If \code{data} is null
then defaults to \code{object[["prior.weights"]]}, otherwise a vector of ones.}

\item{draws}{matrix; user supplied posterior draws to be used when
\code{method = "user"}.}

\item{newdata}{Deprecated: use \code{data} instead.}

\item{ncores}{Deprecated; use \code{n_cores} instead. The number of cores for
generating random variables from a multivariate normal distribution.
Passed to \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}. Parallelization will take place only if
OpenMP is supported (but appears to work on Windows with current \code{R}).}
}
\value{
A tibble (data frame) with 3 columns containing the posterior
predicted values in long format. The columns are
\itemize{
\item \code{row} (integer) the row of \code{data} that each posterior draw relates to,
\item \code{draw} (integer) an index, in range \code{1:n}, indicating which draw each row
relates to,
\item \code{response} (numeric) the predicted response for the indicated row of
\code{data}.
}
}
\description{
Draw samples from the posterior distribution of an estimated model
}
\section{Note}{
Models with offset terms supplied via the \code{offset} argument to
\code{\link[mgcv:gam]{mgcv::gam()}} etc. are ignored by \code{\link[mgcv:predict.gam]{mgcv::predict.gam()}}. As such, this
kind of offset term is also ignored by \code{posterior_samples()}. Offset terms
that are included in the model formula supplied to \code{\link[mgcv:gam]{mgcv::gam()}} etc are
not ignored and the posterior samples produced will reflect those offset
term values. This has the side effect of requiring any new data values
provided to \code{posterior_samples()} via the \code{data} argument must include the
offset variable.
}

\references{
Wood, S.N., (2020). Simplified integrated nested Laplace approximation.
\emph{Biometrika} \strong{107}, 223--230. \doi{10.1093/biomet/asz044}
}
\author{
Gavin L. Simpson
}
